/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionMode;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpClientFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyBroadCastMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.HttpAuthorizationProviderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

public class JettyHttpMessageSenderProvider
implements ProtocolMessageSenderProvider {
    private static final Logger logger = LoggerFactory.getLogger(JettyHttpMessageSenderProvider.class);
    private final HttpClient httpClient;
    private final Optional<HttpClient> http2Client;
    private final EndpointAddressResolver endpointAddressResolver;
    private final MetadataAppender<Request> metadataAppender;
    private final HttpAuthorizationProviderFactory authorizationProviderFactory;

    @Inject
    public JettyHttpMessageSenderProvider(ConfigFactory config, HttpClientFactory httpClientFactory, EndpointAddressResolver endpointAddressResolver, MetadataAppender<Request> metadataAppender, HttpAuthorizationProviderFactory authorizationProviderFactory) {
        this.httpClient = httpClientFactory.provide();
        this.http2Client = config.getBooleanProperty(Configs.CONSUMER_HTTP2_ENABLED) ? Optional.of(httpClientFactory.createClientForHttp2()) : Optional.empty();
        this.endpointAddressResolver = endpointAddressResolver;
        this.metadataAppender = metadataAppender;
        this.authorizationProviderFactory = authorizationProviderFactory;
    }

    @Override
    public MessageSender create(Subscription subscription) {
        EndpointAddress endpoint = subscription.getEndpoint();
        EndpointAddressResolverMetadata endpointAddressResolverMetadata = subscription.getEndpointAddressResolverMetadata();
        ResolvableEndpointAddress resolvableEndpoint = new ResolvableEndpointAddress(endpoint, this.endpointAddressResolver, endpointAddressResolverMetadata);
        HttpRequestFactory requestFactory = this.httpRequestFactory(subscription);
        if (subscription.getMode() == SubscriptionMode.BROADCAST) {
            return new JettyBroadCastMessageSender(requestFactory, resolvableEndpoint);
        }
        return new JettyMessageSender(requestFactory, resolvableEndpoint);
    }

    private HttpRequestFactory httpRequestFactory(Subscription subscription) {
        int requestTimeout = subscription.getSerialSubscriptionPolicy().getRequestTimeout();
        return new HttpRequestFactory(this.getHttpClient(subscription), requestTimeout, this.metadataAppender, this.authorizationProviderFactory.create(subscription));
    }

    private HttpClient getHttpClient(Subscription subscription) {
        if (subscription.isHttp2Enabled()) {
            return this.tryToGetHttp2Client(subscription);
        }
        logger.info("Using http/1.1 for {}.", (Object)subscription.getQualifiedName());
        return this.httpClient;
    }

    private HttpClient tryToGetHttp2Client(Subscription subscription) {
        if (this.http2Client.isPresent()) {
            logger.info("Using http/2 for {}.", (Object)subscription.getQualifiedName());
            return this.http2Client.get();
        }
        logger.info("Using http/1.1 for {}. Http/2 delivery is not enabled on this server.", (Object)subscription.getQualifiedName());
        return this.httpClient;
    }

    @Override
    public void start() throws Exception {
        this.startClient(this.httpClient);
        this.http2Client.ifPresent(this::startClient);
    }

    private void startClient(HttpClient client) {
        if (client.isStopped()) {
            try {
                client.start();
            }
            catch (Exception ex) {
                logger.error("Could not start http client.", (Throwable)ex);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.stopClient(this.httpClient);
        this.http2Client.ifPresent(this::stopClient);
    }

    private void stopClient(HttpClient client) {
        if (client.isRunning()) {
            try {
                client.stop();
            }
            catch (Exception ex) {
                logger.error("Could not stop http client", (Throwable)ex);
            }
        }
    }
}

