/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentCaches;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentRegistry;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class SubscriptionAssignmentRegistryFactory
implements Factory<SubscriptionAssignmentRegistry> {
    private final CuratorFramework curatorClient;
    private final ConfigFactory configFactory;
    private final SubscriptionAssignmentCaches subscriptionAssignmentCaches;

    @Inject
    public SubscriptionAssignmentRegistryFactory(@Named(value="hermesCurator") CuratorFramework curatorClient, ConfigFactory configFactory, SubscriptionAssignmentCaches subscriptionAssignmentCaches) {
        this.curatorClient = curatorClient;
        this.configFactory = configFactory;
        this.subscriptionAssignmentCaches = subscriptionAssignmentCaches;
    }

    public SubscriptionAssignmentRegistry provide() {
        ZookeeperPaths paths = new ZookeeperPaths(this.configFactory.getStringProperty(Configs.ZOOKEEPER_ROOT));
        String cluster = this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
        String consumersRuntimePath = paths.consumersRuntimePath(cluster);
        return new SubscriptionAssignmentRegistry(this.curatorClient, this.subscriptionAssignmentCaches.localClusterCache(), new SubscriptionAssignmentPathSerializer(consumersRuntimePath, SubscriptionAssignmentRegistry.AUTO_ASSIGNED_MARKER));
    }

    public void dispose(SubscriptionAssignmentRegistry instance) {
    }
}

