/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessTokens;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthTokenRequestRateLimiter;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;

public class OAuthSubscriptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(OAuthSubscriptionHandler.class);
    private final SubscriptionName subscriptionName;
    private final String providerName;
    private final OAuthAccessTokens accessTokens;
    private final OAuthTokenRequestRateLimiter rateLimiter;
    private final ScheduledExecutorService executorService;

    public OAuthSubscriptionHandler(SubscriptionName subscriptionName, String providerName, OAuthAccessTokens accessTokens, OAuthTokenRequestRateLimiter rateLimiter) {
        this.subscriptionName = subscriptionName;
        this.providerName = providerName;
        this.accessTokens = accessTokens;
        this.rateLimiter = rateLimiter;
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    public void initialize() {
        this.rateLimiter.tryAcquire();
        this.accessTokens.loadToken(this.subscriptionName);
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void handleSuccess() {
        this.rateLimiter.resetRate();
    }

    public void handleFailed(Subscription subscription, MessageSendingResult result) {
        SubscriptionName subscriptionName = subscription.getQualifiedName();
        if (this.shouldTryRefreshingToken(subscriptionName, result) && this.rateLimiter.tryAcquire()) {
            logger.info("Refreshing token for subscription {}", (Object)subscriptionName);
            this.rateLimiter.reduceRate();
            this.executorService.schedule(() -> this.accessTokens.refreshToken(subscriptionName), 0L, TimeUnit.MILLISECONDS);
        }
    }

    private boolean shouldTryRefreshingToken(SubscriptionName subscriptionName, MessageSendingResult result) {
        return result.getStatusCode() == 401 || !this.accessTokens.tokenExists(subscriptionName);
    }
}

