/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.queue.MonitoredMpscQueue;
import pl.allegro.tech.hermes.consumers.supervisor.process.Signal;

class SignalsFilter {
    private static final Map<Signal.SignalType, Signal.SignalType> MERGEABLE_SIGNALS = ImmutableMap.builder().put((Object)Signal.SignalType.START, (Object)Signal.SignalType.STOP).put((Object)Signal.SignalType.STOP, (Object)Signal.SignalType.START).build();
    private static final Map<Signal.SignalType, Signal.SignalType> OVERRULING_SIGNALS = ImmutableMap.builder().put((Object)Signal.SignalType.START, (Object)Signal.SignalType.KILL_UNHEALTHY).build();
    private final Clock clock;
    private final MonitoredMpscQueue<Signal> taskQueue;

    SignalsFilter(MonitoredMpscQueue<Signal> taskQueue, Clock clock) {
        this.taskQueue = taskQueue;
        this.clock = clock;
    }

    Set<Signal> filterSignals(List<Signal> signals, Set<SubscriptionName> existingConsumers) {
        Set<Signal> filteredSignals = Collections.newSetFromMap(new LinkedHashMap(signals.size()));
        for (Signal signal : signals) {
            boolean merged = this.merge(filteredSignals, signal);
            if (merged) continue;
            this.negate(filteredSignals, signal);
            if (signal.getType() != Signal.SignalType.START && !existingConsumers.contains(signal.getTarget())) continue;
            if (signal.canExecuteNow(this.clock.millis())) {
                filteredSignals.add(signal);
                continue;
            }
            this.taskQueue.offer(signal);
        }
        return filteredSignals;
    }

    private boolean merge(Set<Signal> filteredSignals, Signal signal) {
        Signal.SignalType signalTypeToMerge = MERGEABLE_SIGNALS.get((Object)signal.getType());
        if (signalTypeToMerge != null) {
            return filteredSignals.remove(signal.createChild(signalTypeToMerge));
        }
        return false;
    }

    private void negate(Set<Signal> filteredSignals, Signal signal) {
        Signal.SignalType signalToRemove = OVERRULING_SIGNALS.get((Object)signal.getType());
        if (signalToRemove != null) {
            filteredSignals.remove(signal.createChild(signalToRemove));
        }
    }
}

