/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthProvidersNotifyingCache;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class OAuthProvidersNotifyingCacheFactory
implements Factory<OAuthProvidersNotifyingCache> {
    private final CuratorFramework curator;
    private final ZookeeperPaths paths;
    private final ObjectMapper objectMapper;

    @Inject
    public OAuthProvidersNotifyingCacheFactory(@Named(value="hermesCurator") CuratorFramework curator, ZookeeperPaths paths, ObjectMapper objectMapper) {
        this.curator = curator;
        this.paths = paths;
        this.objectMapper = objectMapper;
    }

    public OAuthProvidersNotifyingCache provide() {
        String path = this.paths.oAuthProvidersPath();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        OAuthProvidersNotifyingCache cache = new OAuthProvidersNotifyingCache(this.curator, path, executorService, this.objectMapper);
        try {
            cache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start Zookeeper cache for path " + path, e);
        }
        return cache;
    }

    public void dispose(OAuthProvidersNotifyingCache instance) {
    }
}

