/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerInstance;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRate;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.RateHistory;

public class NegotiatedMaxRateProvider
implements MaxRateProvider {
    private static final Logger logger = LoggerFactory.getLogger(NegotiatedMaxRateProvider.class);
    private final ConsumerInstance consumer;
    private final MaxRateRegistry registry;
    private final MaxRateSupervisor maxRateSupervisor;
    private final SendCounters sendCounters;
    private final HermesMetrics metrics;
    private final double minSignificantChange;
    private final int historyLimit;
    private volatile Subscription subscription;
    private volatile double maxRate;
    private volatile double previousRecordedRate = -1.0;

    NegotiatedMaxRateProvider(String consumerId, MaxRateRegistry registry, MaxRateSupervisor maxRateSupervisor, Subscription subscription, SendCounters sendCounters, HermesMetrics metrics, double initialMaxRate, double minSignificantChange, int historyLimit) {
        this.consumer = new ConsumerInstance(consumerId, subscription.getQualifiedName());
        this.registry = registry;
        this.maxRateSupervisor = maxRateSupervisor;
        this.subscription = subscription;
        this.sendCounters = sendCounters;
        this.metrics = metrics;
        this.minSignificantChange = minSignificantChange;
        this.historyLimit = historyLimit;
        this.maxRate = initialMaxRate;
    }

    @Override
    public double get() {
        return this.maxRate;
    }

    void tickForHistory() {
        this.recordCurrentRate(this.sendCounters.getRate());
        this.fetchCurrentMaxRate().ifPresent(currentMaxRate -> {
            this.maxRate = currentMaxRate.getMaxRate();
        });
    }

    private void recordCurrentRate(double actualRate) {
        double usedRate = Math.min(actualRate / Math.max(this.maxRate, 1.0), 1.0);
        if (this.shouldRecordHistory(usedRate)) {
            try {
                RateHistory rateHistory = this.registry.getRateHistory(this.consumer);
                RateHistory updatedHistory = RateHistory.updatedRates(rateHistory, usedRate, this.historyLimit);
                this.registry.writeRateHistory(this.consumer, updatedHistory);
                this.previousRecordedRate = usedRate;
            }
            catch (Exception e) {
                logger.warn("Encountered problem updating max rate for {}", (Object)this.consumer, (Object)e);
                this.metrics.rateHistoryFailuresCounter(this.subscription).inc();
            }
        }
    }

    private boolean shouldRecordHistory(double usedRate) {
        return this.previousRecordedRate < 0.0 || Math.abs(this.previousRecordedRate - usedRate) > this.minSignificantChange;
    }

    private Optional<MaxRate> fetchCurrentMaxRate() {
        try {
            return this.registry.getMaxRate(this.consumer);
        }
        catch (Exception e) {
            logger.warn("Encountered problem fetching max rate for {}", (Object)this.consumer);
            this.metrics.maxRateFetchFailuresCounter(this.subscription).inc();
            return Optional.empty();
        }
    }

    @Override
    public void updateSubscription(Subscription newSubscription) {
        this.subscription = newSubscription;
    }

    @Override
    public void start() {
        this.maxRateSupervisor.register(this);
        this.metrics.registerMaxRateGauge(this.subscription, this::get);
        this.metrics.registerRateGauge(this.subscription, this.sendCounters::getRate);
    }

    @Override
    public void shutdown() {
        this.maxRateSupervisor.unregister(this);
        this.metrics.unregisterMaxRateGauge(this.subscription);
        this.metrics.unregisterRateGauge(this.subscription);
    }
}

