/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerRateInfo;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRate;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.RateHistory;

class MaxRateBalancer {
    private static final double ALLOWED_DISTRIBUTION_ERROR = 1.0;
    private final double busyTolerance;
    private final double minMax;
    private final double minAllowedChangePercent;

    MaxRateBalancer(double busyTolerance, double minMax, double minAllowedChangePercent) {
        this.busyTolerance = busyTolerance;
        this.minMax = minMax;
        this.minAllowedChangePercent = minAllowedChangePercent;
    }

    Optional<Map<String, MaxRate>> balance(double subscriptionMax, Set<ConsumerRateInfo> rateInfos) {
        double minChange = this.minAllowedChangePercent / 100.0 * subscriptionMax;
        double defaultRate = Math.max(this.minMax, subscriptionMax / (double)Math.max(1, rateInfos.size()));
        if (this.shouldResortToDefaults(subscriptionMax, rateInfos)) {
            return Optional.of(this.balanceDefault(defaultRate, rateInfos));
        }
        List<ActiveConsumerInfo> activeConsumerInfos = rateInfos.stream().map(ActiveConsumerInfo::convert).collect(Collectors.toList());
        if (this.subscriptionRateChanged(activeConsumerInfos, subscriptionMax)) {
            return Optional.of(this.balanceDefault(defaultRate, rateInfos));
        }
        Map<Boolean, List<ActiveConsumerInfo>> busyOrNot = this.busyOrNot(activeConsumerInfos);
        List<ActiveConsumerInfo> busy = busyOrNot.get(true);
        List<ActiveConsumerInfo> notBusy = busyOrNot.get(false).stream().filter(consumer -> !consumer.getRateHistory().getRates().isEmpty()).collect(Collectors.toList());
        if (busy.isEmpty()) {
            return Optional.empty();
        }
        NotBusyBalancer.Result notBusyChanges = this.handleNotBusy(notBusy, minChange);
        Map<String, MaxRate> busyUpdates = this.handleBusy(minChange, busy, notBusyChanges.getReleasedRate()).calculateNewMaxRates();
        Map<String, MaxRate> notBusyUpdates = notBusyChanges.calculateNewMaxRates();
        return Optional.of(Stream.of(busyUpdates, notBusyUpdates).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private boolean shouldResortToDefaults(double subscriptionMax, Set<ConsumerRateInfo> rateInfos) {
        return this.anyNewConsumers(rateInfos) || this.insufficientSubscriptionRate(subscriptionMax, rateInfos.size());
    }

    private Map<String, MaxRate> balanceDefault(double defaultRate, Set<ConsumerRateInfo> rateInfos) {
        return rateInfos.stream().collect(Collectors.toMap(ConsumerRateInfo::getConsumerId, rateInfo -> new MaxRate(defaultRate)));
    }

    private boolean anyNewConsumers(Set<ConsumerRateInfo> rateInfos) {
        return rateInfos.stream().anyMatch(this::isUnassigned);
    }

    private boolean insufficientSubscriptionRate(double subscriptionMax, int consumersCount) {
        return subscriptionMax / (double)consumersCount <= 1.0;
    }

    private boolean subscriptionRateChanged(List<ActiveConsumerInfo> activeConsumerInfos, double subscriptionMax) {
        double sum = activeConsumerInfos.stream().mapToDouble(ActiveConsumerInfo::getMax).sum();
        return Math.abs(sum - subscriptionMax) > 1.0;
    }

    private boolean isUnassigned(ConsumerRateInfo rateInfo) {
        return !rateInfo.getMaxRate().isPresent();
    }

    private Map<Boolean, List<ActiveConsumerInfo>> busyOrNot(List<ActiveConsumerInfo> infos) {
        return infos.stream().collect(Collectors.partitioningBy(this::isBusy));
    }

    private boolean isBusy(ActiveConsumerInfo info) {
        return info.getRateHistory().getRates().stream().mapToDouble(Double::doubleValue).average().orElse(0.0) > 1.0 - this.busyTolerance;
    }

    private NotBusyBalancer.Result handleNotBusy(List<ActiveConsumerInfo> notBusy, double minChange) {
        return new NotBusyBalancer(notBusy, minChange, this.minMax).balance();
    }

    private BusyBalancer.Result handleBusy(double minChange, List<ActiveConsumerInfo> busy, double freedByNotBusy) {
        return new BusyBalancer(busy, freedByNotBusy, minChange).balance();
    }

    private static class ConsumerRateChange {
        private String consumerId;
        private double currentMax;
        private double rateChange;

        ConsumerRateChange(String consumerId, double currentMax, double rateChange) {
            this.consumerId = consumerId;
            this.currentMax = currentMax;
            this.rateChange = rateChange;
        }

        String getConsumerId() {
            return this.consumerId;
        }

        double getCurrentMax() {
            return this.currentMax;
        }

        double getRateChange() {
            return this.rateChange;
        }
    }

    private static class BusyBalancer {
        private final List<ActiveConsumerInfo> consumerInfos;
        private final double freedByNotBusy;
        private final double minChange;

        BusyBalancer(List<ActiveConsumerInfo> consumerInfos, double freedByNotBusy, double minChange) {
            this.consumerInfos = consumerInfos;
            this.freedByNotBusy = freedByNotBusy;
            this.minChange = minChange;
        }

        Result balance() {
            double busyMaxSum = this.consumerInfos.stream().mapToDouble(ActiveConsumerInfo::getMax).sum();
            List<ConsumerMaxShare> shares = this.consumerInfos.stream().map(info -> new ConsumerMaxShare(info.getConsumerId(), info.getMax(), info.getMax() / busyMaxSum)).collect(Collectors.toList());
            if (shares.size() == 1) {
                return new Result(this.distribute(this.freedByNotBusy, shares));
            }
            double equalShare = busyMaxSum / (double)this.consumerInfos.size();
            Map<Boolean, List<ConsumerMaxShare>> greedyOrNot = shares.stream().collect(Collectors.partitioningBy(share -> share.getCurrentMax() > equalShare + this.minChange));
            List<ConsumerMaxShare> greedy = greedyOrNot.get(true);
            List<ConsumerMaxShare> notGreedy = greedyOrNot.get(false);
            List greedySubtracts = greedy.stream().map(share -> {
                double toDistribute = this.takeAwayFromGreedy(share.getCurrentMax(), share.getShare(), equalShare);
                return new ConsumerRateChange(share.getConsumerId(), ((ConsumerMaxShare)share).currentMax, -toDistribute);
            }).collect(Collectors.toList());
            double toDistribute = this.freedByNotBusy - greedySubtracts.stream().mapToDouble(ConsumerRateChange::getRateChange).sum();
            List<ConsumerMaxShare> notGreedyShares = this.recalculateShare(notGreedy);
            List<ConsumerRateChange> notGreedyAdds = this.distribute(toDistribute, notGreedyShares);
            return new Result(Stream.concat(notGreedyAdds.stream(), greedySubtracts.stream()).collect(Collectors.toList()));
        }

        private double takeAwayFromGreedy(double currentMax, double share, double equalShare) {
            double scale = 2.0 / (share + 1.0) - 1.0;
            double changeProposal = currentMax / 2.0 * scale;
            double actualChange = Math.max(changeProposal, this.minChange);
            return currentMax - actualChange > equalShare ? actualChange : currentMax - equalShare;
        }

        private List<ConsumerMaxShare> recalculateShare(List<ConsumerMaxShare> shares) {
            double sum = shares.stream().mapToDouble(ConsumerMaxShare::getCurrentMax).sum();
            return shares.stream().map(previous -> new ConsumerMaxShare(previous.getConsumerId(), previous.getCurrentMax(), ((ConsumerMaxShare)previous).currentMax / sum)).collect(Collectors.toList());
        }

        private List<ConsumerRateChange> distribute(double maxAmount, List<ConsumerMaxShare> shares) {
            return shares.stream().map(share -> new ConsumerRateChange(((ConsumerMaxShare)share).consumerId, share.getCurrentMax(), share.getShare() * maxAmount)).collect(Collectors.toList());
        }

        private static class ConsumerMaxShare {
            private final String consumerId;
            private final double currentMax;
            private final double share;

            ConsumerMaxShare(String consumerId, double currentMax, double share) {
                this.consumerId = consumerId;
                this.currentMax = currentMax;
                this.share = share;
            }

            String getConsumerId() {
                return this.consumerId;
            }

            double getCurrentMax() {
                return this.currentMax;
            }

            double getShare() {
                return this.share;
            }
        }

        private static class Result {
            private final List<ConsumerRateChange> changes;

            Result(List<ConsumerRateChange> changes) {
                this.changes = changes;
            }

            Map<String, MaxRate> calculateNewMaxRates() {
                return this.changes.stream().collect(Collectors.toMap(ConsumerRateChange::getConsumerId, change -> new MaxRate(change.getCurrentMax() + change.getRateChange())));
            }
        }
    }

    private static class NotBusyBalancer {
        private final List<ActiveConsumerInfo> consumerInfos;
        private final double minChange;
        private final double minMax;

        NotBusyBalancer(List<ActiveConsumerInfo> consumerInfos, double minChange, double minMax) {
            this.consumerInfos = consumerInfos;
            this.minChange = minChange;
            this.minMax = minMax;
        }

        Result balance() {
            List<ConsumerRateChange> changes = this.consumerInfos.stream().map(ri -> {
                double currentMax = ri.getMax();
                double toDistribute = this.takeAwayFromNotBusy(ri.getRateHistory(), currentMax);
                return new ConsumerRateChange(ri.getConsumerId(), currentMax, -toDistribute);
            }).collect(Collectors.toList());
            return new Result(changes);
        }

        private double takeAwayFromNotBusy(RateHistory history, double currentMax) {
            double usedRatio = history.getRates().get(0);
            double scalingFactor = 2.0 / (usedRatio + 1.0) - 1.0;
            double proposedChange = scalingFactor * currentMax;
            double actualChange = proposedChange > this.minChange ? proposedChange : 0.0;
            return currentMax - actualChange > this.minMax ? actualChange : currentMax - this.minMax;
        }

        private static class Result {
            private final List<ConsumerRateChange> changes;
            private final double releasedRate;

            Result(List<ConsumerRateChange> changes) {
                this.changes = changes;
                this.releasedRate = -changes.stream().mapToDouble(ConsumerRateChange::getRateChange).sum();
            }

            double getReleasedRate() {
                return this.releasedRate;
            }

            Map<String, MaxRate> calculateNewMaxRates() {
                return this.changes.stream().collect(Collectors.toMap(ConsumerRateChange::getConsumerId, change -> new MaxRate(change.getCurrentMax() + change.getRateChange())));
            }
        }
    }

    private static class ActiveConsumerInfo {
        private final String consumerId;
        private final RateHistory rateHistory;
        private final Double max;

        ActiveConsumerInfo(String consumerId, RateHistory rateHistory, Double max) {
            this.consumerId = consumerId;
            this.rateHistory = rateHistory;
            this.max = max;
        }

        static ActiveConsumerInfo convert(ConsumerRateInfo rateInfo) {
            return new ActiveConsumerInfo(rateInfo.getConsumerId(), rateInfo.getHistory(), rateInfo.getMaxRate().get().getMaxRate());
        }

        String getConsumerId() {
            return this.consumerId;
        }

        RateHistory getRateHistory() {
            return this.rateHistory;
        }

        Double getMax() {
            return this.max;
        }
    }
}

