/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.List;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentAware;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;

public class SubscriptionAssignmentRegistry
implements SubscriptionAssignmentAware {
    public static final byte[] AUTO_ASSIGNED_MARKER = "AUTO_ASSIGNED".getBytes();
    private final CuratorFramework curator;
    private final SubscriptionAssignmentPathSerializer pathSerializer;
    private final SubscriptionAssignmentCache subscriptionAssignmentCache;

    public SubscriptionAssignmentRegistry(CuratorFramework curator, SubscriptionAssignmentCache subscriptionAssignmentCache, SubscriptionAssignmentPathSerializer pathSerializer) {
        this.curator = curator;
        this.pathSerializer = pathSerializer;
        this.subscriptionAssignmentCache = subscriptionAssignmentCache;
    }

    public void start() throws Exception {
        this.subscriptionAssignmentCache.registerAssignmentCallback(this);
    }

    public boolean isStarted() {
        return this.subscriptionAssignmentCache.isStarted();
    }

    @Override
    public void onSubscriptionAssigned(SubscriptionName subscriptionName) {
    }

    @Override
    public void onAssignmentRemoved(SubscriptionName subscriptionName) {
        this.removeSubscriptionEntryIfEmpty(subscriptionName);
    }

    @Override
    public Optional<String> watchedConsumerId() {
        return Optional.empty();
    }

    public void registerAssignmentCallback(SubscriptionAssignmentAware callback) {
        this.subscriptionAssignmentCache.registerAssignmentCallback(callback);
    }

    boolean isAssignedTo(String nodeId, SubscriptionName subscription) {
        return this.subscriptionAssignmentCache.isAssignedTo(nodeId, subscription);
    }

    public SubscriptionAssignmentView createSnapshot() {
        return this.subscriptionAssignmentCache.createSnapshot();
    }

    void dropAssignment(SubscriptionAssignment assignment) {
        this.askCuratorPolitely(() -> {
            Void cfr_ignored_0 = (Void)this.curator.delete().guaranteed().forPath(this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId()));
        });
    }

    void addPersistentAssignment(SubscriptionAssignment assignment) {
        this.addAssignment(assignment, CreateMode.PERSISTENT);
    }

    void addEphemeralAssignment(SubscriptionAssignment assignment) {
        this.addAssignment(assignment, CreateMode.EPHEMERAL);
    }

    private void removeSubscriptionEntryIfEmpty(SubscriptionName subscriptionName) {
        this.askCuratorPolitely(() -> {
            if (((List)this.curator.getChildren().forPath(this.pathSerializer.serialize(subscriptionName))).isEmpty()) {
                this.curator.delete().guaranteed().forPath(this.pathSerializer.serialize(subscriptionName));
            }
        });
    }

    private void addAssignment(SubscriptionAssignment assignment, CreateMode createMode) {
        this.askCuratorPolitely(() -> {
            String path = this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId());
            ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(createMode)).forPath(path, AUTO_ASSIGNED_MARKER);
        });
    }

    private void askCuratorPolitely(CuratorTask task) {
        try {
            task.run();
        }
        catch (KeeperException.NoNodeException | KeeperException.NodeExistsException throwable) {
        }
        catch (Exception ex) {
            throw new InternalProcessingException((Throwable)ex);
        }
    }

    static interface CuratorTask {
        public void run() throws Exception;
    }
}

