/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.chain;

import com.google.common.base.Joiner;
import java.util.Optional;

public final class FilterResult {
    private final boolean filtered;
    private final Optional<String> filterType;
    private final Optional<String> message;
    private final Optional<Exception> cause;
    public static final FilterResult PASS = new FilterResult(false, Optional.empty(), Optional.empty(), Optional.empty());

    public static FilterResult failed(String filterType, String message) {
        return new FilterResult(true, Optional.of(filterType), Optional.ofNullable(message), Optional.empty());
    }

    public static FilterResult failed(String filterType, Exception exception) {
        return new FilterResult(true, Optional.of(filterType), Optional.empty(), Optional.ofNullable(exception));
    }

    private FilterResult(boolean filtered, Optional<String> filterType, Optional<String> message, Optional<Exception> cause) {
        this.filtered = filtered;
        this.filterType = filterType;
        this.message = message;
        this.cause = cause;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public Optional<String> getFilterType() {
        return this.filterType;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<Exception> getCause() {
        return this.cause;
    }

    public String toString() {
        return "[" + Joiner.on((String)",").skipNulls().join((Object)String.format("%s={%s}", "filtered", this.filtered), (Object)this.toString("filterType", this.filterType), new Object[]{this.toString("message", this.message), this.toString("cause", this.cause)}) + "]";
    }

    private String toString(String fieldName, Optional<?> value) {
        return value.map(v -> String.format("%s={%s}", fieldName, v)).orElse(null);
    }
}

