/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import java.util.Objects;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.kafka.KafkaTopicName;

public class SubscriptionPartition {
    private final KafkaTopicName kafkaTopicName;
    private final SubscriptionName subscription;
    private final int partition;

    public SubscriptionPartition(KafkaTopicName kafkaTopicName, SubscriptionName subscription, int partition) {
        this.kafkaTopicName = kafkaTopicName;
        this.subscription = subscription;
        this.partition = partition;
    }

    public static SubscriptionPartition subscriptionPartition(String kafkaTopicName, String subscriptionName, int partition) {
        return new SubscriptionPartition(KafkaTopicName.valueOf((String)kafkaTopicName), SubscriptionName.fromString((String)subscriptionName), partition);
    }

    public KafkaTopicName getKafkaTopicName() {
        return this.kafkaTopicName;
    }

    public SubscriptionName getSubscriptionName() {
        return this.subscription;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPartition that = (SubscriptionPartition)o;
        return this.partition == that.partition && Objects.equals(this.subscription, that.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.subscription, this.partition);
    }

    public String toString() {
        return "SubscriptionPartition{subscription=" + this.subscription + ", partition=" + this.partition + '}';
    }
}

