/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.api.Result;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResultLogInfo;
import pl.allegro.tech.hermes.consumers.consumer.sender.SingleMessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;

public interface MessageSendingResult {
    public static final String CAUSE_UNKNOWN = "unknown";

    public static SingleMessageSendingResult succeededResult() {
        return new SingleMessageSendingResult(Response.Status.OK.getStatusCode());
    }

    public static SingleMessageSendingResult succeededResult(URI requestURI) {
        return new SingleMessageSendingResult(Response.Status.OK.getStatusCode(), requestURI);
    }

    public static SingleMessageSendingResult failedResult(Throwable cause) {
        return new SingleMessageSendingResult(cause);
    }

    public static SingleMessageSendingResult failedResult(EndpointAddressResolutionException cause) {
        return new SingleMessageSendingResult(cause, cause.isIgnoreInRateCalculation());
    }

    public static SingleMessageSendingResult failedResult(int statusCode) {
        return new SingleMessageSendingResult(statusCode);
    }

    public static SingleMessageSendingResult ofStatusCode(int statusCode) {
        return new SingleMessageSendingResult(statusCode);
    }

    public static SingleMessageSendingResult retryAfter(int seconds) {
        return new SingleMessageSendingResult(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), TimeUnit.SECONDS.toMillis(seconds));
    }

    public static SingleMessageSendingResult of(Result result) {
        return new SingleMessageSendingResult(result);
    }

    public String getRootCause();

    public int getStatusCode();

    public boolean isLoggable();

    public Optional<Long> getRetryAfterMillis();

    public boolean isClientError();

    public boolean isTimeout();

    public boolean succeeded();

    public boolean ignoreInRateCalculation(boolean var1, boolean var2);

    default public boolean hasHttpAnswer() {
        return this.getStatusCode() != 0;
    }

    public boolean isRetryLater();

    public List<MessageSendingResultLogInfo> getLogInfo();

    public List<URI> getSucceededUris(Predicate<MessageSendingResult> var1);

    default public String getHostname() {
        return this.getLogInfo().stream().filter(i -> i.getUrl().isPresent()).map(i -> i.getUrl().get().getHost()).collect(Collectors.joining(","));
    }
}

