/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResultLogInfo;
import pl.allegro.tech.hermes.consumers.consumer.sender.SingleMessageSendingResult;

public class MultiMessageSendingResult
implements MessageSendingResult {
    private final List<SingleMessageSendingResult> children;

    public MultiMessageSendingResult(List<SingleMessageSendingResult> children) {
        this.children = ImmutableList.copyOf(children);
    }

    @Override
    public int getStatusCode() {
        if (this.succeeded()) {
            return this.children.stream().mapToInt(MessageSendingResult::getStatusCode).max().orElse(0);
        }
        return this.children.stream().filter(child -> !child.succeeded()).mapToInt(MessageSendingResult::getStatusCode).max().orElse(0);
    }

    @Override
    public boolean isLoggable() {
        return this.children.stream().anyMatch(MessageSendingResult::isLoggable);
    }

    @Override
    public boolean ignoreInRateCalculation(boolean retryClientErrors, boolean isOAuthSecuredSubscription) {
        return this.children.stream().allMatch(r -> r.ignoreInRateCalculation(retryClientErrors, isOAuthSecuredSubscription));
    }

    @Override
    public Optional<Long> getRetryAfterMillis() {
        return this.children.stream().map(MessageSendingResult::getRetryAfterMillis).filter(Optional::isPresent).map(Optional::get).min(Comparator.naturalOrder());
    }

    @Override
    public boolean succeeded() {
        return !this.children.isEmpty() && this.children.stream().allMatch(MessageSendingResult::succeeded);
    }

    @Override
    public boolean isClientError() {
        List failed = this.children.stream().filter(child -> !child.succeeded()).collect(Collectors.toList());
        return !failed.isEmpty() && failed.stream().allMatch(MessageSendingResult::isClientError);
    }

    @Override
    public boolean isTimeout() {
        return !this.children.isEmpty() && this.children.stream().anyMatch(MessageSendingResult::isTimeout);
    }

    @Override
    public boolean isRetryLater() {
        return this.children.isEmpty() || this.children.stream().anyMatch(MessageSendingResult::isRetryLater);
    }

    @Override
    public List<MessageSendingResultLogInfo> getLogInfo() {
        return this.children.stream().map(child -> new MessageSendingResultLogInfo(child.getRequestUri(), child.getFailure(), child.getRootCause())).collect(Collectors.toList());
    }

    @Override
    public List<URI> getSucceededUris(Predicate<MessageSendingResult> filter) {
        return this.children.stream().filter(filter).map(SingleMessageSendingResult::getRequestUri).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<SingleMessageSendingResult> getChildren() {
        return this.children;
    }

    @Override
    public String getRootCause() {
        return this.children.stream().map(child -> child.getRequestUri().map(Object::toString).orElse("") + ":" + child.getRootCause()).collect(Collectors.joining(";"));
    }
}

