/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.chain;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.filtering.MessageFilter;
import pl.allegro.tech.hermes.consumers.consumer.filtering.MessageFilterSource;
import pl.allegro.tech.hermes.consumers.consumer.filtering.chain.FilterChain;

public class FilterChainFactory {
    private MessageFilterSource availableFilters;

    @Inject
    public FilterChainFactory(MessageFilterSource filters) {
        this.availableFilters = filters;
    }

    public FilterChain create(Subscription subscription) {
        Stream globalFilters = this.availableFilters.getGlobalFilters().stream();
        Stream<MessageFilter> subscriptionFilters = subscription.getFilters().stream().map(this.availableFilters::compile);
        return new FilterChain(Stream.concat(globalFilters, subscriptionFilters).collect(Collectors.toList()));
    }
}

