/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Optional;
import javax.inject.Inject;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.ssl.JvmKeystoreSslContextFactory;
import pl.allegro.tech.hermes.common.ssl.KeystoreProperties;
import pl.allegro.tech.hermes.common.ssl.SslContextFactory;

public class SslContextFactoryProvider {
    @Inject
    @org.jvnet.hk2.annotations.Optional
    SslContextFactory sslContextFactory;
    @Inject
    ConfigFactory configFactory;

    public SslContextFactory getSslContextFactory() {
        return Optional.ofNullable(this.sslContextFactory).orElse(this.getDefault());
    }

    private SslContextFactory getDefault() {
        String protocol = this.configFactory.getStringProperty(Configs.CONSUMER_SSL_PROTOCOL);
        KeystoreProperties keystoreProperties = new KeystoreProperties(this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_LOCATION), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_FORMAT), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_PASSWORD));
        KeystoreProperties truststoreProperties = new KeystoreProperties(this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_LOCATION), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_FORMAT), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_PASSWORD));
        return new JvmKeystoreSslContextFactory(protocol, keystoreProperties, truststoreProperties);
    }
}

