/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.converter;

import java.io.IOException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.converter.MessageConverter;
import tech.allegro.schema.json2avro.converter.AvroConversionException;
import tech.allegro.schema.json2avro.converter.JsonAvroConverter;

public class AvroToJsonMessageConverter
implements MessageConverter {
    private final JsonAvroConverter converter = new JsonAvroConverter();

    @Inject
    public AvroToJsonMessageConverter() {
    }

    @Override
    public Message convert(Message message, Topic topic) {
        return Message.message().fromMessage(message).withContentType(ContentType.JSON).withData(this.converter.convertToJson(this.recordWithoutMetadata(message.getData(), (Schema)message.getSchema().get().getSchema()))).withNoSchema().build();
    }

    private GenericRecord recordWithoutMetadata(byte[] data, Schema schema) {
        GenericRecord original = this.originalRecord(data, schema);
        Schema schemaWithoutMetadata = this.removeMetadataField(schema);
        GenericRecordBuilder builder = new GenericRecordBuilder(schemaWithoutMetadata);
        schemaWithoutMetadata.getFields().forEach(field -> builder.set(field, original.get(field.name())));
        return builder.build();
    }

    private Schema removeMetadataField(Schema schema) {
        return Schema.createRecord(schema.getFields().stream().filter(field -> !"__metadata".equals(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue())).collect(Collectors.toList()));
    }

    private GenericRecord originalRecord(byte[] data, Schema schema) {
        try {
            BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder(data, null);
            return (GenericRecord)new GenericDatumReader(schema).read(null, (Decoder)binaryDecoder);
        }
        catch (IOException e) {
            throw new AvroConversionException("Failed to create avro record.", (Throwable)e);
        }
    }
}

