/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.avro;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang.StringUtils;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.common.message.converter.AvroRecordToBytesConverter;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.filtering.FilteringException;
import pl.allegro.tech.hermes.schema.CompiledSchema;

public class AvroPathPredicate
implements Predicate<Message> {
    private static final String WILDCARD_IDX = "*";
    private static final String GROUP_SELECTOR = "selector";
    private static final String GROUP_IDX = "index";
    private static final String ARRAY_PATTERN_SELECTOR_PART = "(?<selector>..*)";
    private static final String ARRAY_PATTERN_IDX_PART = "\\[(?<index>\\*|\\d+)]";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(?<selector>..*)\\[(?<index>\\*|\\d+)]");
    private static final String NULL_AS_STRING = "null";
    private List<String> path;
    private Pattern pattern;

    public AvroPathPredicate(String path, Pattern pattern) {
        this.path = Arrays.asList(StringUtils.strip((String)path, (String)".").split("\\."));
        this.pattern = pattern;
    }

    @Override
    public boolean test(Message message) {
        FilteringException.check(message.getContentType() == ContentType.AVRO, "This filter supports only AVRO contentType.");
        try {
            List<Object> result = this.select(message);
            return !result.isEmpty() && result.stream().map(Object::toString).allMatch(this::matches);
        }
        catch (Exception exception) {
            throw new FilteringException(exception);
        }
    }

    private List<Object> select(Message message) throws IOException {
        CompiledSchema compiledSchema = message.getSchema().get();
        return this.select(AvroRecordToBytesConverter.bytesToRecord((byte[])message.getData(), (Schema)((Schema)compiledSchema.getSchema())));
    }

    private List<Object> select(GenericRecord record) {
        ListIterator<String> iter = this.path.listIterator();
        return this.select(record, iter);
    }

    private List<Object> select(Object record, ListIterator<String> iter) {
        Object current = record;
        while (iter.hasNext() && current instanceof GenericRecord) {
            GenericRecord currentRecord = (GenericRecord)current;
            String selector = iter.next();
            Matcher arrayMatcher = ARRAY_PATTERN.matcher(selector);
            if (arrayMatcher.matches()) {
                String idx = arrayMatcher.group(GROUP_IDX);
                selector = arrayMatcher.group(GROUP_SELECTOR);
                current = currentRecord.get(selector);
                if (!(current instanceof GenericArray)) {
                    return Collections.emptyList();
                }
                GenericArray currentArray = (GenericArray)current;
                if (idx.equals(WILDCARD_IDX)) {
                    return this.selectMultipleArrayItems(iter, (GenericArray<Object>)currentArray);
                }
                current = this.selectSingleArrayItem(Integer.valueOf(idx), (GenericArray<Object>)currentArray);
                continue;
            }
            current = currentRecord.get(selector);
        }
        return iter.hasNext() ? Collections.emptyList() : Collections.singletonList(current == null ? NULL_AS_STRING : current);
    }

    private List<Object> selectMultipleArrayItems(ListIterator<String> iter, GenericArray<Object> currentArray) {
        return currentArray.stream().map(item -> this.select(item, iter.hasNext() ? this.path.listIterator(iter.nextIndex()) : Collections.emptyListIterator())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Object selectSingleArrayItem(int idx, GenericArray<Object> currentArray) {
        if (currentArray.size() <= idx) {
            return null;
        }
        return currentArray.get(idx);
    }

    private boolean matches(Object value) {
        return this.pattern.matcher(Objects.toString(value)).matches();
    }
}

