/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.filtering.FilteringException;

public class JsonPathPredicate
implements Predicate<Message> {
    private Configuration configuration;
    private String path;
    private Pattern matcher;

    public JsonPathPredicate(String path, Pattern matcher, Configuration configuration) {
        this.path = path;
        this.matcher = matcher;
        this.configuration = configuration;
    }

    @Override
    public boolean test(Message message) {
        FilteringException.check(message.getContentType() == ContentType.JSON, "This filter supports only JSON contentType.");
        try {
            List result = (List)JsonPath.parse((InputStream)new ByteArrayInputStream(message.getData()), (Configuration)this.configuration).read(this.path, new com.jayway.jsonpath.Predicate[0]);
            return !result.isEmpty() && result.stream().map(Objects::toString).allMatch(o -> this.matcher.matcher((CharSequence)o).matches());
        }
        catch (Exception ex) {
            throw new FilteringException(ex);
        }
    }
}

