/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.ActiveConsumerCounter;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerMaxRateStrategy;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.NegotiatedMaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.StrictMaxRateProvider;

public class MaxRateProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(MaxRateProviderFactory.class);
    private final Creator providerCreator;

    @Inject
    public MaxRateProviderFactory(ConfigFactory configFactory, MaxRateRegistry maxRateRegistry, MaxRateSupervisor maxRateSupervisor, ActiveConsumerCounter activeConsumerCounter, HermesMetrics metrics) {
        String strategy = configFactory.getStringProperty(Configs.CONSUMER_MAXRATE_STRATEGY);
        logger.info("Max rate provider strategy chosen: {}", (Object)strategy);
        switch (strategy) {
            case "negotiated": {
                this.checkNegotiatedSettings(configFactory);
                this.providerCreator = (subscription, sendCounters) -> {
                    String consumerId = configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID);
                    int historyLimit = configFactory.getIntProperty(Configs.CONSUMER_MAXRATE_HISTORY_SIZE);
                    double initialMaxRate = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_MAX_RATE);
                    double minSignificantChange = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_SIGNIFICANT_UPDATE_PERCENT) / 100.0;
                    return new NegotiatedMaxRateProvider(consumerId, maxRateRegistry, maxRateSupervisor, subscription, sendCounters, metrics, initialMaxRate, minSignificantChange, historyLimit);
                };
                break;
            }
            case "strict": {
                this.providerCreator = (subscription, sendCounters) -> new StrictMaxRateProvider(activeConsumerCounter, subscription);
                break;
            }
            default: {
                throw new ConsumerMaxRateStrategy.UnknownMaxRateStrategyException();
            }
        }
    }

    public MaxRateProvider create(Subscription subscription, SendCounters sendCounters) {
        return this.providerCreator.create(subscription, sendCounters);
    }

    private void checkNegotiatedSettings(ConfigFactory configFactory) {
        double minSignificantChange = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_SIGNIFICANT_UPDATE_PERCENT) / 100.0;
        double busyTolerance = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_BUSY_TOLERANCE);
        Preconditions.checkArgument((busyTolerance > minSignificantChange ? 1 : 0) != 0, (String)"Significant rate change (%s) can't be higher than busy tolerance (%s)", (Object)minSignificantChange, (Object)busyTolerance);
    }

    private static interface Creator {
        public MaxRateProvider create(Subscription var1, SendCounters var2);
    }
}

