/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.ApacheHttpClientMessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.SimpleEndpointAddressResolver;

public class HttpMessageBatchSenderFactory
implements MessageBatchSenderFactory {
    private ConfigFactory configFactory;

    @Inject
    public HttpMessageBatchSenderFactory(ConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    @Override
    public MessageBatchSender create(Subscription subscription) {
        Preconditions.checkState((boolean)subscription.getEndpoint().getProtocol().contains("http"), (Object)"Batching is only supported for http/s currently.");
        return new ApacheHttpClientMessageBatchSender(this.configFactory.getIntProperty(Configs.CONSUMER_BATCH_CONNECTION_TIMEOUT), this.configFactory.getIntProperty(Configs.CONSUMER_BATCH_SOCKET_TIMEOUT), new SimpleEndpointAddressResolver());
    }
}

