/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.HttpAuthorizationProvider;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

class HttpRequestFactory {
    private final HttpClient client;
    private final long timeout;
    private final MetadataAppender<Request> metadataAppender;
    private final Optional<HttpAuthorizationProvider> authorizationProvider;
    private final Function<ContentType, String> contentTypeToMediaType = contentType -> ContentType.AVRO.equals(contentType) ? "avro/binary" : "application/json";

    HttpRequestFactory(HttpClient client, long timeout, MetadataAppender<Request> metadataAppender, Optional<HttpAuthorizationProvider> authorizationProvider) {
        this.client = client;
        this.timeout = timeout;
        this.metadataAppender = metadataAppender;
        this.authorizationProvider = authorizationProvider;
    }

    Request buildRequest(Message message, URI uri) {
        Request request = this.client.newRequest(uri).method(HttpMethod.POST).header(HttpHeader.KEEP_ALIVE.toString(), "true").header(MessageMetadataHeaders.MESSAGE_ID.getName(), message.getId()).header(MessageMetadataHeaders.RETRY_COUNT.getName(), Integer.toString(message.getRetryCounter())).header(HttpHeader.CONTENT_TYPE.toString(), this.contentTypeToMediaType.apply(message.getContentType())).timeout(this.timeout, TimeUnit.MILLISECONDS).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{message.getData()}));
        if (message.hasSubscriptionIdentityHeaders()) {
            request.header(MessageMetadataHeaders.TOPIC_NAME.getName(), message.getTopic());
            request.header(MessageMetadataHeaders.SUBSCRIPTION_NAME.getName(), message.getSubscription());
        }
        message.getSchema().ifPresent(schema -> request.header(MessageMetadataHeaders.SCHEMA_VERSION.getName(), String.valueOf(schema.getVersion().value())));
        this.authorizationProvider.ifPresent(p -> p.authorizationToken().ifPresent(token -> request.header(HttpHeader.AUTHORIZATION.toString(), token)));
        this.metadataAppender.append(request, message);
        message.getAdditionalHeaders().forEach(header -> request.header(header.getName(), header.getValue()));
        return request;
    }
}

