/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.CompletableFutureAwareMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;

public class JettyMessageSender
extends CompletableFutureAwareMessageSender {
    private final HttpRequestFactory requestFactory;
    private final ResolvableEndpointAddress endpoint;

    public JettyMessageSender(HttpRequestFactory requestFactory, ResolvableEndpointAddress endpoint) {
        this.requestFactory = requestFactory;
        this.endpoint = endpoint;
    }

    @Override
    protected void sendMessage(Message message, CompletableFuture<MessageSendingResult> resultFuture) {
        try {
            this.requestFactory.buildRequest(message, this.endpoint.resolveFor(message)).send(result -> resultFuture.complete(MessageSendingResult.of(result)));
        }
        catch (EndpointAddressResolutionException exception) {
            resultFuture.complete(MessageSendingResult.failedResult(exception));
        }
    }

    @Override
    public void stop() {
    }
}

