/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcess;

class RunningConsumerProcess {
    private static final Logger logger = LoggerFactory.getLogger(RunningConsumerProcess.class);
    private ConsumerProcess process;
    private Future executionHandle;
    private Clock clock;
    private Optional<Long> timeOfDeath = Optional.empty();

    RunningConsumerProcess(ConsumerProcess process, Future executionHandle, Clock clock) {
        this.process = process;
        this.executionHandle = executionHandle;
        this.clock = clock;
    }

    private RunningConsumerProcess(ConsumerProcess process, Future executionHandle, long killTime, Clock clock) {
        this(process, executionHandle, clock);
        this.timeOfDeath = Optional.of(killTime);
    }

    void cancel() {
        this.timeOfDeath.ifPresent(timeOfDeath -> {
            SubscriptionName subscriptionName = this.process.getSubscriptionName();
            logger.info("Canceling consumer process for subscription {}. It should have been killed {}ms ago.", (Object)subscriptionName, (Object)(this.clock.millis() - timeOfDeath));
            if (this.executionHandle.cancel(true)) {
                logger.info("Canceled consumer process for subscription {}", (Object)subscriptionName);
            } else {
                logger.error("Failed to cancel consumer process for {}.", (Object)subscriptionName);
            }
        });
    }

    boolean shouldBeCanceledNow() {
        return this.timeOfDeath.map(time -> time < this.clock.millis() && !this.executionHandle.isDone()).orElse(false);
    }

    RunningConsumerProcess copyWithTimeOfDeath(long timeOfDeath) {
        return new RunningConsumerProcess(this.process, this.executionHandle, timeOfDeath, this.clock);
    }

    ConsumerProcess getConsumerProcess() {
        return this.process;
    }

    public Subscription getSubscription() {
        return this.getConsumerProcess().getSubscription();
    }
}

