/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.List;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;

public class WorkTracker {
    private final String consumerNodeId;
    private final SubscriptionAssignmentRegistry registry;

    public WorkTracker(String consumerNodeId, SubscriptionAssignmentRegistry registry) {
        this.consumerNodeId = consumerNodeId;
        this.registry = registry;
    }

    public boolean isReady() {
        return this.registry.isStarted();
    }

    public void forceAssignment(Subscription subscription) {
        this.registry.addEphemeralAssignment(new SubscriptionAssignment(this.consumerNodeId, subscription.getQualifiedName()));
    }

    public void dropAssignment(Subscription subscription) {
        this.registry.dropAssignment(new SubscriptionAssignment(this.consumerNodeId, subscription.getQualifiedName()));
    }

    public WorkDistributionChanges apply(SubscriptionAssignmentView initialState, SubscriptionAssignmentView targetView) {
        List<SubscriptionAssignment> assignmentDeletions = initialState.deletions(targetView).getAllAssignments();
        List<SubscriptionAssignment> assignmentAdditions = initialState.additions(targetView).getAllAssignments();
        assignmentDeletions.forEach(this.registry::dropAssignment);
        assignmentAdditions.forEach(this.registry::addPersistentAssignment);
        return new WorkDistributionChanges(assignmentDeletions.size(), assignmentAdditions.size());
    }

    public SubscriptionAssignmentView getAssignments() {
        return this.registry.createSnapshot();
    }

    public boolean isAssignedTo(SubscriptionName subscription, String consumerNodeId) {
        return this.registry.isAssignedTo(consumerNodeId, subscription);
    }

    public static class WorkDistributionChanges {
        private final int assignmentsDeleted;
        private final int assignmentsCreated;

        public WorkDistributionChanges(int assignmentsDeleted, int assignmentsCreated) {
            this.assignmentsDeleted = assignmentsDeleted;
            this.assignmentsCreated = assignmentsCreated;
        }

        public int getDeletedAssignmentsCount() {
            return this.assignmentsDeleted;
        }

        public int getCreatedAssignmentsCount() {
            return this.assignmentsCreated;
        }

        public String toString() {
            return String.format("assignments_created=%d, assignments_deleted=%d", this.assignmentsCreated, this.assignmentsDeleted);
        }
    }
}

