/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.selective;

import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

public class ConsumerNodesRegistry
extends PathChildrenCache
implements PathChildrenCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerNodesRegistry.class);
    private final CuratorFramework curatorClient;
    private final String consumerNodeId;
    private final String prefix;
    private final LeaderLatch leaderLatch;
    private final Map<String, Long> consumersLastSeen = new HashMap<String, Long>();
    private final long deathOfConsumerAfterMillis;
    private final Clock clock;

    public ConsumerNodesRegistry(CuratorFramework curatorClient, ExecutorService executorService, String prefix, String consumerNodeId, int deathOfConsumerAfterSeconds, Clock clock) {
        super(curatorClient, ConsumerNodesRegistry.getNodesPath(prefix), true, false, executorService);
        this.curatorClient = curatorClient;
        this.consumerNodeId = consumerNodeId;
        this.prefix = prefix;
        this.clock = clock;
        this.leaderLatch = new LeaderLatch(curatorClient, this.getLeaderPath(), consumerNodeId);
        this.deathOfConsumerAfterMillis = TimeUnit.SECONDS.toMillis(deathOfConsumerAfterSeconds);
    }

    public void start() throws Exception {
        this.getListenable().addListener((Object)this);
        super.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        switch (event.getType()) {
            case INITIALIZED: 
            case CONNECTION_RECONNECTED: {
                if (this.isRegistered(this.consumerNodeId)) break;
                this.registerConsumerNode();
            }
        }
    }

    public boolean isRegistered(String consumerNodeId) {
        try {
            return this.curatorClient.checkExists().forPath(this.getNodePath(consumerNodeId)) != null;
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    void startLeaderLatch() {
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    void stopLeaderLatch() {
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    boolean isLeader() {
        return this.ensureRegistered() && this.leaderLatch.hasLeadership();
    }

    List<String> list() {
        return new ArrayList<String>(this.consumersLastSeen.keySet());
    }

    void refresh() {
        logger.info("Refreshing current consumers registry");
        long currentTime = this.clock.millis();
        this.readCurrentNodes().forEach(node -> this.consumersLastSeen.put((String)node, currentTime));
        List<String> deadConsumers = this.findDeadConsumers(currentTime);
        if (!deadConsumers.isEmpty()) {
            logger.info("Considering following consumers dead: {}", deadConsumers);
        }
        deadConsumers.forEach(this.consumersLastSeen::remove);
    }

    private boolean ensureRegistered() {
        if (this.curatorClient.getZookeeperClient().isConnected()) {
            if (!this.isRegistered(this.consumerNodeId)) {
                this.registerConsumerNode();
            }
            return true;
        }
        return false;
    }

    private void registerConsumerNode() {
        try {
            ((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.getNodePath(this.consumerNodeId));
            logger.info("Registered in consumer nodes registry as {}", (Object)this.consumerNodeId);
            this.refresh();
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    private String getNodePath(String consumerNodeId) {
        return ConsumerNodesRegistry.getNodesPath(this.prefix) + "/" + consumerNodeId;
    }

    private static String getNodesPath(String prefix) {
        return prefix + "/nodes";
    }

    private String getLeaderPath() {
        return this.prefix + "/leader";
    }

    private List<String> findDeadConsumers(long currentTime) {
        long tooOld = currentTime - this.deathOfConsumerAfterMillis;
        return this.consumersLastSeen.entrySet().stream().filter(entry -> {
            long lastSeen = (Long)entry.getValue();
            return lastSeen < tooOld;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private List<String> readCurrentNodes() {
        return this.getCurrentData().stream().map(data -> StringUtils.substringAfterLast((String)data.getPath(), (String)"/")).collect(Collectors.toList());
    }

    public String getId() {
        return this.consumerNodeId;
    }
}

