/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetCommitQueueMonitor;

final class OffsetCommitQueue {
    private final NavigableMap<Long, Boolean> offsets = new TreeMap<Long, Boolean>();
    private final OffsetCommitQueueMonitor monitor;

    OffsetCommitQueue(OffsetCommitQueueMonitor monitor) {
        this.monitor = monitor;
    }

    synchronized void put(long offset) {
        this.offsets.put(offset, false);
    }

    synchronized void markDelivered(long offset) {
        this.offsets.put(offset, true);
    }

    synchronized Optional<Long> poll() {
        Long offsetToCommit = null;
        if (this.firstOffsetDelivered()) {
            do {
                offsetToCommit = this.offsets.pollFirstEntry().getKey();
            } while (this.firstOffsetDelivered());
            this.monitor.newOffsetCommit();
        } else if (!this.empty()) {
            this.monitor.nothingNewToCommit(this.offsets.size(), this.offsets.firstEntry().getKey());
        }
        return Optional.ofNullable(offsetToCommit);
    }

    private boolean firstOffsetDelivered() {
        return !this.empty() && this.offsets.firstEntry().getValue() != false;
    }

    private boolean empty() {
        return this.offsets.isEmpty();
    }
}

