/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;

public class MessageSenderProviders {
    private final Map<String, ProtocolMessageSenderProvider> messageSendersProviders = new HashMap<String, ProtocolMessageSenderProvider>();

    public void put(String protocol, ProtocolMessageSenderProvider provider) {
        this.messageSendersProviders.put(protocol, provider);
    }

    public void putIfProtocolAbsent(String protocol, ProtocolMessageSenderProvider provider) {
        this.messageSendersProviders.putIfAbsent(protocol, provider);
    }

    public Optional<ProtocolMessageSenderProvider> get(String protocol) {
        return Optional.ofNullable(this.messageSendersProviders.get(protocol));
    }

    public void startAll() {
        this.messageSendersProviders.values().forEach(provider -> {
            try {
                provider.start();
            }
            catch (Exception e) {
                throw new InternalProcessingException("Something went wrong while starting message sender provider", (Throwable)e);
            }
        });
    }

    public void stopAll() {
        this.messageSendersProviders.values().forEach(provider -> {
            try {
                provider.stop();
            }
            catch (Exception e) {
                throw new InternalProcessingException("Something went wrong while stopping message sender provider", (Throwable)e);
            }
        });
    }
}

