/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.api.Result;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

public class MessageSendingResult {
    public static final String UNKNOWN_CAUSE = "unknown";
    private Throwable failure;
    private boolean loggable = false;
    private Response.Status.Family responseFamily;

    public MessageSendingResult() {
    }

    public MessageSendingResult(Throwable failure) {
        this.failure = failure;
    }

    public MessageSendingResult(Throwable failure, boolean loggable) {
        this.failure = failure;
        this.loggable = loggable;
    }

    public MessageSendingResult(Result result) {
        if (result.isFailed()) {
            this.failure = result.getFailure();
            if (result.getResponse() != null) {
                this.responseFamily = Response.Status.Family.familyOf((int)result.getResponse().getStatus());
            }
        } else {
            this.initializeForStatusCode(result.getResponse().getStatus());
        }
    }

    public MessageSendingResult(int statusCode) {
        this.initializeForStatusCode(statusCode);
    }

    public boolean succeeded() {
        return this.failure == null;
    }

    public boolean isClientError() {
        return this.isInFamily(Response.Status.Family.CLIENT_ERROR);
    }

    private void initializeForStatusCode(int statusCode) {
        this.responseFamily = Response.Status.Family.familyOf((int)statusCode);
        if (!this.isInFamily(Response.Status.Family.SUCCESSFUL)) {
            this.failure = new InternalProcessingException("Message sending failed with status code:" + statusCode);
        }
    }

    private boolean isInFamily(Response.Status.Family family) {
        Preconditions.checkNotNull((Object)family);
        return family.equals((Object)this.responseFamily);
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public String getRootCause() {
        return this.failure != null ? Throwables.getRootCause((Throwable)this.failure).getMessage() : UNKNOWN_CAUSE;
    }

    public boolean isLoggable() {
        return this.loggable;
    }

    public static MessageSendingResult succeededResult() {
        return new MessageSendingResult();
    }

    public static MessageSendingResult failedResult(Throwable cause) {
        return new MessageSendingResult(cause);
    }

    public static MessageSendingResult failedResult(int statusCode) {
        return new MessageSendingResult(statusCode);
    }

    public static MessageSendingResult loggedFailResult(Throwable cause) {
        return new MessageSendingResult(cause, true);
    }
}

