/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.receiver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class Message {
    private final Optional<String> id;
    private final long offset;
    private final int partition;
    private String topic;
    private Optional<Long> publishingTimestamp;
    private Optional<Long> readingTimestamp;
    private final byte[] data;

    public Message(Optional<String> id, long offset, int partition, String topic, byte[] content, Optional<Long> publishingTimestamp, Optional<Long> readingTimestamp) {
        this.id = id;
        this.offset = offset;
        this.partition = partition;
        this.data = content;
        this.topic = topic;
        this.publishingTimestamp = publishingTimestamp;
        this.readingTimestamp = readingTimestamp;
    }

    public Optional<Long> getPublishingTimestamp() {
        return this.publishingTimestamp;
    }

    public Optional<Long> getReadingTimestamp() {
        return this.readingTimestamp;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getPartition() {
        return this.partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isTtlExceeded(int ttlSeconds) {
        long currentTimestamp = System.currentTimeMillis();
        return this.readingTimestamp.isPresent() && currentTimestamp > this.readingTimestamp.get() + TimeUnit.SECONDS.toMillis(ttlSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.partition, this.topic, this.data, this.publishingTimestamp, this.readingTimestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.offset, other.offset) && Objects.equals(this.partition, other.partition) && Objects.equals(this.topic, other.topic) && Objects.equals(this.publishingTimestamp, other.publishingTimestamp) && Objects.equals(this.readingTimestamp, other.readingTimestamp) && Arrays.equals(this.data, other.data);
    }

    public boolean isEmpty() {
        return ArrayUtils.isEmpty((byte[])this.data);
    }

    public Optional<String> getId() {
        return this.id;
    }
}

