/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.CookieStore;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.HttpCookieStore;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;

public class HttpClientFactory
implements Factory<HttpClient> {
    private final ConfigFactory configFactory;

    @Inject
    public HttpClientFactory(ConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    public HttpClient provide() {
        HttpClient client = new HttpClient();
        client.setMaxConnectionsPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_MAX_CONNECTIONS_PER_DESTINATION));
        client.setMaxRequestsQueuedPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_CONNECTIONS_QUEUE));
        client.setExecutor((Executor)Executors.newFixedThreadPool(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_THREAD_POOL_SIZE)));
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        return client;
    }

    public void dispose(HttpClient instance) {
    }
}

