/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.ConsumerMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionOffsetCommitQueues;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimiter;
import pl.allegro.tech.hermes.consumers.consumer.receiver.Message;
import pl.allegro.tech.hermes.consumers.consumer.receiver.SplitMessagesReceiver;
import pl.allegro.tech.hermes.consumers.message.tracker.Trackers;
import pl.allegro.tech.hermes.domain.subscription.offset.PartitionOffset;

public class Consumer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Consumer.class);
    private final SplitMessagesReceiver messageReceiver;
    private final HermesMetrics hermesMetrics;
    private final ConsumerRateLimiter rateLimiter;
    private final SubscriptionOffsetCommitQueues subscriptionOffsetCommitQueues;
    private final Semaphore inflightSemaphore;
    private final Trackers trackers;
    private final ConsumerMessageSender sender;
    private Subscription subscription;
    private volatile boolean consuming = true;

    public Consumer(SplitMessagesReceiver messageReceiver, HermesMetrics hermesMetrics, Subscription subscription, ConsumerRateLimiter rateLimiter, SubscriptionOffsetCommitQueues subscriptionOffsetCommitQueues, ConsumerMessageSender sender, Semaphore inflightSemaphore, Trackers trackers) {
        this.messageReceiver = messageReceiver;
        this.hermesMetrics = hermesMetrics;
        this.subscription = subscription;
        this.rateLimiter = rateLimiter;
        this.subscriptionOffsetCommitQueues = subscriptionOffsetCommitQueues;
        this.sender = sender;
        this.inflightSemaphore = inflightSemaphore;
        this.trackers = trackers;
    }

    private String getId() {
        return this.subscription.getId();
    }

    @Override
    public void run() {
        this.setThreadName();
        this.rateLimiter.initialize();
        while (this.isConsuming()) {
            try {
                this.inflightSemaphore.acquire();
                List<Message> messages = this.readMessages();
                if (messages.isEmpty()) {
                    this.inflightSemaphore.release();
                }
                this.sendMessages(messages);
            }
            catch (Exception e) {
                LOGGER.error("Consumer loop failed for " + this.getId(), (Throwable)e);
            }
        }
        LOGGER.info("Stopping consumer for subscription {}", (Object)this.subscription.getId());
        this.messageReceiver.stop();
    }

    private List<Message> readMessages() {
        Timer.Context ctx = this.hermesMetrics.timer("consumer.$hostname.read-latency").time();
        List<Message> messages = this.messageReceiver.next();
        ctx.close();
        return messages;
    }

    private void sendMessages(List<Message> messages) {
        for (Message message : messages) {
            this.subscriptionOffsetCommitQueues.put(message);
            this.hermesMetrics.incrementInflightCounter(this.subscription);
            this.trackers.get(this.subscription).logInflight(message, this.subscription);
            this.sender.sendMessage(message);
        }
    }

    public void stopConsuming() {
        this.rateLimiter.shutdown();
        this.sender.shutdown();
        this.consuming = false;
    }

    public List<PartitionOffset> getOffsetsToCommit() {
        return this.subscriptionOffsetCommitQueues.getOffsetsToCommit();
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void updateSubscription(Subscription newSubscription) {
        this.rateLimiter.updateSubscription(newSubscription);
        this.sender.updateSubscription(newSubscription);
        this.subscription = newSubscription;
    }

    private void setThreadName() {
        Thread.currentThread().setName("Consumer-" + this.subscription.getId());
    }

    @VisibleForTesting
    protected boolean isConsuming() {
        return this.consuming;
    }
}

