/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset.kafka;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.metric.counter.MetricsDeltaCalculator;
import pl.allegro.tech.hermes.consumers.consumer.offset.AsyncOffsetMonitor;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.KafkaLatestOffsetReader;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.KafkaOffsetMonitor;
import pl.allegro.tech.hermes.domain.subscription.offset.PartitionOffset;

public class KafkaAsyncOffsetMonitor
implements AsyncOffsetMonitor {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private KafkaLatestOffsetReader kafkaLatestOffsetReader;
    private HermesMetrics hermesMetrics;
    private MetricsDeltaCalculator metricsDeltaCalculator = new MetricsDeltaCalculator();

    @Inject
    public KafkaAsyncOffsetMonitor(KafkaLatestOffsetReader kafkaLatestOffsetReader, HermesMetrics hermesMetrics) {
        this.kafkaLatestOffsetReader = kafkaLatestOffsetReader;
        this.hermesMetrics = hermesMetrics;
    }

    @Override
    public void process(Map<Subscription, PartitionOffset> offsetsPerSubscription) {
        this.executorService.execute(new KafkaOffsetMonitor(offsetsPerSubscription, this.kafkaLatestOffsetReader, this.hermesMetrics, this.metricsDeltaCalculator));
    }

    @VisibleForTesting
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

