/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionOffsetCommitQueues;
import pl.allegro.tech.hermes.consumers.consumer.receiver.Message;
import pl.allegro.tech.hermes.consumers.consumer.result.AbstractHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.SuccessHandler;
import pl.allegro.tech.hermes.consumers.message.tracker.Trackers;

public class DefaultSuccessHandler
extends AbstractHandler
implements SuccessHandler {
    private final Trackers trackers;

    public DefaultSuccessHandler(SubscriptionOffsetCommitQueues offsetHelper, HermesMetrics hermesMetrics, Trackers trackers) {
        super(offsetHelper, hermesMetrics);
        this.trackers = trackers;
    }

    @Override
    public void handle(Message message, Subscription subscription) {
        this.offsetHelper.decrement(message.getPartition(), message.getOffset());
        this.updateMeters(subscription);
        this.updateMetrics("consumer.$hostname.delivered.$group.$topic.$subscription", message, subscription);
        this.trackers.get(subscription).logSent(message, subscription);
    }

    private void updateMeters(Subscription subscription) {
        this.hermesMetrics.meter("consumer.$hostname.meter").mark();
        this.hermesMetrics.meter("consumer.$hostname.meter.$group.$topic", subscription.getTopicName()).mark();
        this.hermesMetrics.meter("consumer.$hostname.meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark();
    }
}

