/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.CookieStore;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.HttpCookieStore;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedExecutorService;

public class HttpClientFactory
implements Factory<HttpClient> {
    private final ConfigFactory configFactory;
    private final HermesMetrics hermesMetrics;

    @Inject
    public HttpClientFactory(ConfigFactory configFactory, HermesMetrics hermesMetrics) {
        this.configFactory = configFactory;
        this.hermesMetrics = hermesMetrics;
    }

    public HttpClient provide() {
        HttpClient client = new HttpClient();
        client.setMaxConnectionsPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_MAX_CONNECTIONS_PER_DESTINATION));
        client.setMaxRequestsQueuedPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_CONNECTIONS_QUEUE));
        client.setExecutor((Executor)this.getExecutor());
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        return client;
    }

    private ExecutorService getExecutor() {
        ExecutorService wrapped = Executors.newFixedThreadPool(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_THREAD_POOL_SIZE));
        return new InstrumentedExecutorService(wrapped, this.hermesMetrics, "jetty-http-client");
    }

    public void dispose(HttpClient instance) {
    }
}

