/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.timeout;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedScheduledExecutorService;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.timeout.FutureAsyncTimeout;

public class FutureAsyncTimeoutFactory
implements Factory<FutureAsyncTimeout<MessageSendingResult>> {
    private final ScheduledExecutorService timeoutExecutorService;

    @Inject
    public FutureAsyncTimeoutFactory(ConfigFactory configFactory, HermesMetrics hermesMetrics) {
        this.timeoutExecutorService = new InstrumentedScheduledExecutorService(Executors.newScheduledThreadPool(configFactory.getIntProperty(Configs.CONSUMER_SENDER_ASYNC_TIMEOUT_THREAD_POOL_SIZE)), hermesMetrics, "async-timeout");
    }

    public FutureAsyncTimeout<MessageSendingResult> provide() {
        return new FutureAsyncTimeout<MessageSendingResult>(MessageSendingResult::loggedFailResult, this.timeoutExecutorService);
    }

    public void dispose(FutureAsyncTimeout instance) {
        instance.shutdown();
    }
}

