/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.jvnet.hk2.component.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.di.CommonBinder;
import pl.allegro.tech.hermes.common.hook.Hook;
import pl.allegro.tech.hermes.common.hook.HooksHandler;
import pl.allegro.tech.hermes.consumers.consumer.health.HealthCheckServer;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSenderProviders;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.di.ConsumersBinder;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;

public class HermesConsumers {
    private static final Logger logger = LoggerFactory.getLogger(HermesConsumers.class);
    private final HooksHandler hooksHandler;
    private final ConsumersSupervisor consumersSupervisor;
    private final HealthCheckServer healthCheckServer;
    private MultiMap<String, Supplier<ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers;
    private final MessageSenderProviders messageSendersProviders;
    private final ServiceLocator serviceLocator;

    public static void main(String ... args) {
        HermesConsumers.consumers().build().start();
    }

    private HermesConsumers(HooksHandler hooksHandler, List<Binder> binders, MultiMap<String, Supplier<ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers) {
        this.hooksHandler = hooksHandler;
        this.messageSenderProvidersSuppliers = messageSenderProvidersSuppliers;
        this.serviceLocator = this.createDIContainer(binders);
        this.consumersSupervisor = (ConsumersSupervisor)this.serviceLocator.getService(ConsumersSupervisor.class, new Annotation[0]);
        this.healthCheckServer = (HealthCheckServer)this.serviceLocator.getService(HealthCheckServer.class, new Annotation[0]);
        this.messageSendersProviders = (MessageSenderProviders)this.serviceLocator.getService(MessageSenderProviders.class, new Annotation[0]);
        hooksHandler.addShutdownHook(() -> {
            try {
                this.healthCheckServer.stop();
                this.consumersSupervisor.shutdown();
                this.serviceLocator.shutdown();
            }
            catch (InterruptedException e) {
                logger.error("Exception while shutdown Hermes Consumers", (Throwable)e);
            }
        });
    }

    public void start() {
        try {
            this.messageSenderProvidersSuppliers.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(supplier -> this.messageSendersProviders.put((String)entry.getKey(), (ProtocolMessageSenderProvider)supplier.get())));
            this.consumersSupervisor.start();
            this.healthCheckServer.start();
            this.hooksHandler.startup();
        }
        catch (Exception e) {
            logger.error("Exception while starting Hermes Consumers", (Throwable)e);
        }
    }

    public void stop() {
        this.hooksHandler.shutdown();
    }

    private ServiceLocator createDIContainer(List<Binder> binders) {
        String uniqueName = "HermesConsumersLocator" + UUID.randomUUID();
        return ServiceLocatorUtilities.bind((String)uniqueName, (Binder[])binders.toArray(new Binder[binders.size()]));
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.serviceLocator.getService(clazz, new Annotation[0]);
    }

    public <T> T getService(Class<T> clazz, String name) {
        return (T)this.serviceLocator.getService(clazz, name, new Annotation[0]);
    }

    public static Builder consumers() {
        return new Builder();
    }

    public static final class Builder {
        private final HooksHandler hooksHandler = new HooksHandler();
        private final MessageSenderProviders messageSendersProviders = new MessageSenderProviders();
        private final MultiMap<String, Supplier<ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers = new MultiMap();
        private final List<Binder> binders = Lists.newArrayList((Object[])new Binder[]{new CommonBinder(), new ConsumersBinder(), new ProtocolMessageSenderProvidersBinder()});

        public Builder withShutdownHook(Hook hook) {
            this.hooksHandler.addShutdownHook(hook);
            return this;
        }

        public Builder withStartupHook(Hook hook) {
            this.hooksHandler.addStartupHook(hook);
            return this;
        }

        public Builder withMessageSenderProvider(String protocol, Supplier<ProtocolMessageSenderProvider> messageSenderProviderSupplier) {
            this.messageSenderProvidersSuppliers.add((Object)protocol, messageSenderProviderSupplier);
            return this;
        }

        public <T> Builder withBinding(T instance, Class<T> clazz) {
            return this.withBinding(instance, clazz, clazz.getName());
        }

        public <T> Builder withBinding(final T instance, final Class<T> clazz, final String name) {
            int rankHigherThanDefault = 10;
            this.binders.add((Binder)new AbstractBinder(){

                protected void configure() {
                    this.bind(instance).to(clazz).named(name).ranked(10);
                }
            });
            return this;
        }

        public HermesConsumers build() {
            return new HermesConsumers(this.hooksHandler, this.binders, this.messageSenderProvidersSuppliers);
        }

        private final class ProtocolMessageSenderProvidersBinder
        extends AbstractBinder {
            private ProtocolMessageSenderProvidersBinder() {
            }

            protected void configure() {
                this.bind(Builder.this.messageSendersProviders).to(MessageSenderProviders.class);
            }
        }
    }
}

