/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.health;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;

public class HealthCheckServer {
    private final HttpServer server;

    @Inject
    public HealthCheckServer(ConfigFactory configFactory) throws IOException {
        this.server = this.createServer(configFactory.getIntProperty(Configs.CONSUMER_HEALTH_CHECK_PORT));
        this.server.createContext("/status/health", new HealthCheckHandler());
    }

    private HttpServer createServer(int port) throws IOException {
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
        httpServer.setExecutor(null);
        return httpServer;
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }

    private static class HealthCheckHandler
    implements HttpHandler {
        private HealthCheckHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String response = "{\"status\": \"UP\"}";
            httpExchange.sendResponseHeaders(Response.Status.OK.getStatusCode(), response.length());
            OutputStream os = httpExchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        }
    }
}

