/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.metric.counter.MetricsDeltaCalculator;
import pl.allegro.tech.hermes.common.time.Clock;

public class OffsetCommitQueueMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetCommitQueueMonitor.class);
    private final Subscription subscription;
    private final Integer partition;
    private final HermesMetrics hermesMetrics;
    private final Clock clock;
    private final MetricsDeltaCalculator metricsDeltaCalculator;
    private Long offset;
    private Long offsetChangeTimestampSec;
    private final long offsetCommitQueueAlertSize;
    private final long offsetCommitAdditionalIdlePeriodAlert;

    public OffsetCommitQueueMonitor(Subscription subscription, Integer partition, HermesMetrics hermesMetrics, Clock clock, int offsetCommitAdditionalIdlePeriodAlert, int offsetCommitQueueAlertSize) {
        this.subscription = subscription;
        this.partition = partition;
        this.hermesMetrics = hermesMetrics;
        this.clock = clock;
        this.offsetCommitAdditionalIdlePeriodAlert = offsetCommitAdditionalIdlePeriodAlert;
        this.offsetCommitQueueAlertSize = offsetCommitQueueAlertSize;
        this.metricsDeltaCalculator = new MetricsDeltaCalculator();
    }

    public void nothingNewToCommit(long size, long firstOffset) {
        if (this.offset != null && firstOffset == this.offset) {
            if (this.alertSizeExceeded(size) || this.idlePeriodDurationAlert()) {
                this.reportIdlenessPeriod();
                LOGGER.warn("Commit queue idle for partition {} / {}. Current size {}", new Object[]{this.subscription.getName(), this.partition, size});
            }
        } else {
            this.offset = firstOffset;
            this.offsetChangeTimestampSec = this.currentTimestampSec();
        }
    }

    public void newOffsetCommit() {
        this.removeCounter();
        this.offset = null;
        this.offsetChangeTimestampSec = null;
    }

    private boolean idlePeriodDurationAlert() {
        return this.offsetChangeTimestampSec + this.offsetCommitAdditionalIdlePeriodAlert + (long)this.subscription.getSubscriptionPolicy().getMessageTtl().intValue() < this.currentTimestampSec();
    }

    private boolean alertSizeExceeded(long size) {
        return size > this.offsetCommitQueueAlertSize;
    }

    private void removeCounter() {
        this.hermesMetrics.removeCounterForOffsetCommitIdlePeriod(this.subscription, this.partition.intValue());
        this.metricsDeltaCalculator.clear();
    }

    private void reportIdlenessPeriod() {
        long idlenessPeriod = this.currentTimestampSec() - this.offsetChangeTimestampSec;
        this.hermesMetrics.counterForOffsetCommitIdlePeriod(this.subscription, this.partition.intValue()).inc(this.metricsDeltaCalculator.calculateDelta(this.subscription.getId() + "_" + this.partition, Long.valueOf(idlenessPeriod)));
    }

    private long currentTimestampSec() {
        return this.clock.getTime() / 1000L;
    }
}

