/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.message.tracker;

import javax.inject.Inject;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.time.Clock;
import pl.allegro.tech.hermes.consumers.consumer.receiver.Message;
import pl.allegro.tech.hermes.consumers.message.tracker.LogRepository;
import pl.allegro.tech.hermes.consumers.message.tracker.SendingTracker;

public class SendingMessageTracker
implements SendingTracker {
    private final LogRepository repository;
    private final Clock clock;

    @Inject
    SendingMessageTracker(LogRepository repository, Clock clock) {
        this.repository = repository;
        this.clock = clock;
    }

    @Override
    public void logSent(Message message, Subscription subscription) {
        this.repository.logSuccessful(message, this.clock.getTime(), subscription.getQualifiedTopicName(), subscription.getName());
    }

    @Override
    public void logFailed(Message message, Subscription subscription, String reason) {
        this.repository.logFailed(message, this.clock.getTime(), subscription.getQualifiedTopicName(), subscription.getName(), reason);
    }

    @Override
    public void logDiscarded(Message message, Subscription subscription, String reason) {
        this.repository.logDiscarded(message, this.clock.getTime(), subscription.getQualifiedTopicName(), subscription.getName(), reason);
    }

    @Override
    public void logInflight(Message message, Subscription subscription) {
        this.repository.logInflight(message, this.clock.getTime(), subscription.getQualifiedTopicName(), subscription.getName());
    }
}

