/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.subscription.cache.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.cache.zookeeper.StartableCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionCallback;

class SubscriptionsNodeCache
extends StartableCache<SubscriptionCallback>
implements PathChildrenCacheListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionsNodeCache.class);
    private final ObjectMapper objectMapper;

    public SubscriptionsNodeCache(CuratorFramework client, ObjectMapper objectMapper, String path, ExecutorService executorService) {
        super(client, path, executorService);
        this.objectMapper = objectMapper;
        this.getListenable().addListener((Object)this);
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (event.getData() == null || event.getData().getData() == null) {
            LOGGER.warn("Unrecognized event {}", (Object)event);
            return;
        }
        String path = event.getData().getPath();
        Subscription subscription = this.readSubscription(event);
        LOGGER.info("Got subscription change event for path {} type {}", (Object)path, (Object)event.getType());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Event data {}", (Object)new String(event.getData().getData(), Charsets.UTF_8));
        }
        switch (event.getType()) {
            case CHILD_ADDED: {
                for (SubscriptionCallback callback : this.callbacks) {
                    callback.onSubscriptionCreated(subscription);
                }
                break;
            }
            case CHILD_REMOVED: {
                for (SubscriptionCallback callback : this.callbacks) {
                    callback.onSubscriptionRemoved(subscription);
                }
                break;
            }
            case CHILD_UPDATED: {
                for (SubscriptionCallback callback : this.callbacks) {
                    callback.onSubscriptionChanged(subscription);
                }
                break;
            }
        }
    }

    private Subscription readSubscription(PathChildrenCacheEvent event) throws IOException {
        return (Subscription)this.objectMapper.readValue(event.getData().getData(), Subscription.class);
    }
}

