/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.utils;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;

public class SubscriptionSuspender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionSuspender.class);
    private SubscriptionRepository subscriptionRepository;

    @Inject
    public SubscriptionSuspender(SubscriptionRepository subscriptionRepository) {
        this.subscriptionRepository = subscriptionRepository;
    }

    public void suspend(Subscription subscription) {
        Subscription actualSubscription = this.subscriptionRepository.getSubscriptionDetails(subscription.getTopicName(), subscription.getName());
        if (Subscription.State.SUSPENDED == actualSubscription.getState()) {
            LOGGER.warn("Can't suspend subscription {}. Subscription already suspended", (Object)subscription.getId());
            return;
        }
        actualSubscription.setState(Subscription.State.SUSPENDED);
        LOGGER.warn("Suspending subscription {}", (Object)subscription.getId());
        this.subscriptionRepository.updateSubscription(actualSubscription);
    }
}

