/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.utils;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class UriUtils {
    private UriUtils() {
    }

    public static String extractHostFromUri(URI uri) {
        return uri.getHost().replace("/", "");
    }

    public static Integer extractPortFromUri(URI uri) {
        return uri.getPort() > 0 ? Integer.valueOf(uri.getPort()) : null;
    }

    public static String extractAddressFromUri(URI uri) {
        String address = uri.getHost().replace("/", "");
        if (uri.getPort() > 0) {
            address = address + ":" + uri.getPort();
        }
        return address;
    }

    public static String extractUserNameFromUri(URI uri) {
        if (uri.getRawUserInfo() == null) {
            return null;
        }
        List<String> userInfoParts = UriUtils.splitUserInfo(uri);
        if (userInfoParts.isEmpty()) {
            return null;
        }
        return userInfoParts.get(0);
    }

    public static String extractPasswordFromUri(URI uri) {
        if (uri.getRawUserInfo() == null) {
            return null;
        }
        List<String> userInfoParts = UriUtils.splitUserInfo(uri);
        if (userInfoParts.size() <= 1) {
            return null;
        }
        return userInfoParts.get(1);
    }

    public static String extractContextFromUri(URI uri) {
        return StringUtils.substringAfter((String)uri.toString(), (String)uri.getAuthority());
    }

    public static String extractDestinationTopicFromUri(URI uri) {
        return uri.getPath().replace("/", "");
    }

    public static URI appendContext(URI uri, String context) {
        return URI.create(StringUtils.removeEnd((String)uri.toString(), (String)"/") + "/" + StringUtils.removeStart((String)context, (String)"/"));
    }

    private static List<String> splitUserInfo(URI uri) {
        return Splitter.on((String)":").splitToList((CharSequence)uri.getRawUserInfo());
    }
}

