/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.jvnet.hk2.component.MultiMap;
import pl.allegro.tech.hermes.common.di.CommonBinder;
import pl.allegro.tech.hermes.common.hook.Hook;
import pl.allegro.tech.hermes.common.hook.HooksHandler;
import pl.allegro.tech.hermes.consumers.HermesConsumers;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSenderProviders;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.di.ConsumersBinder;
import pl.allegro.tech.hermes.consumers.di.TrackersBinder;
import pl.allegro.tech.hermes.tracker.consumers.LogRepository;

public final class HermesConsumersBuilder {
    private final HooksHandler hooksHandler = new HooksHandler();
    private final MessageSenderProviders messageSendersProviders = new MessageSenderProviders();
    private final MultiMap<String, Supplier<ProtocolMessageSenderProvider>> messageSenderProvidersSuppliers = new MultiMap();
    private final List<Function<ServiceLocator, LogRepository>> logRepositories = new ArrayList<Function<ServiceLocator, LogRepository>>();
    private final List<Binder> binders = Lists.newArrayList((Object[])new Binder[]{new CommonBinder(), new ConsumersBinder(), new ProtocolMessageSenderProvidersBinder()});

    public HermesConsumersBuilder withShutdownHook(Hook hook) {
        this.hooksHandler.addShutdownHook(hook);
        return this;
    }

    public HermesConsumersBuilder withStartupHook(Hook hook) {
        this.hooksHandler.addStartupHook(hook);
        return this;
    }

    public HermesConsumersBuilder withMessageSenderProvider(String protocol, Supplier<ProtocolMessageSenderProvider> messageSenderProviderSupplier) {
        this.messageSenderProvidersSuppliers.add((Object)protocol, messageSenderProviderSupplier);
        return this;
    }

    public HermesConsumersBuilder withLogRepository(Function<ServiceLocator, LogRepository> logRepository) {
        this.logRepositories.add(logRepository);
        return this;
    }

    public <T> HermesConsumersBuilder withBinding(T instance, Class<T> clazz) {
        return this.withBinding(instance, clazz, clazz.getName());
    }

    public <T> HermesConsumersBuilder withBinding(final T instance, final Class<T> clazz, final String name) {
        int rankHigherThanDefault = 10;
        this.binders.add((Binder)new AbstractBinder(){

            protected void configure() {
                this.bind(instance).to(clazz).named(name).ranked(10);
            }
        });
        return this;
    }

    public HermesConsumers build() {
        this.binders.add((Binder)new TrackersBinder(new ArrayList<LogRepository>()));
        return new HermesConsumers(this.hooksHandler, this.binders, this.messageSenderProvidersSuppliers, this.logRepositories);
    }

    private final class ProtocolMessageSenderProvidersBinder
    extends AbstractBinder {
        private ProtocolMessageSenderProvidersBinder() {
        }

        protected void configure() {
            this.bind(HermesConsumersBuilder.this.messageSendersProviders).to(MessageSenderProviders.class);
        }
    }
}

