/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class Message {
    private String id;
    private long offset;
    private int partition;
    private String topic;
    private long publishingTimestamp;
    private long readingTimestamp;
    private byte[] data;

    private Message() {
    }

    public Message(String id, long offset, int partition, String topic, byte[] content, long publishingTimestamp, long readingTimestamp) {
        this.id = id;
        this.offset = offset;
        this.partition = partition;
        this.data = content;
        this.topic = topic;
        this.publishingTimestamp = publishingTimestamp;
        this.readingTimestamp = readingTimestamp;
    }

    public long getPublishingTimestamp() {
        return this.publishingTimestamp;
    }

    public long getReadingTimestamp() {
        return this.readingTimestamp;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getPartition() {
        return this.partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isTtlExceeded(int ttlSeconds) {
        long currentTimestamp = System.currentTimeMillis();
        return currentTimestamp > this.readingTimestamp + TimeUnit.SECONDS.toMillis(ttlSeconds);
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.partition, this.topic, this.data, this.publishingTimestamp, this.readingTimestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.offset, other.offset) && Objects.equals(this.partition, other.partition) && Objects.equals(this.topic, other.topic) && Objects.equals(this.publishingTimestamp, other.publishingTimestamp) && Objects.equals(this.readingTimestamp, other.readingTimestamp) && Arrays.equals(this.data, other.data);
    }

    public static Builder message() {
        return new Builder();
    }

    static /* synthetic */ byte[] access$402(Message x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    public static class Builder {
        private final Message message = new Message();

        public Builder fromMessage(Message message) {
            this.message.id = message.getId();
            this.message.offset = message.getOffset();
            this.message.partition = message.getPartition();
            Message.access$402(this.message, message.getData());
            this.message.topic = message.getTopic();
            this.message.publishingTimestamp = message.getPublishingTimestamp();
            this.message.readingTimestamp = message.getReadingTimestamp();
            return this;
        }

        public Builder withData(byte[] data) {
            Message.access$402(this.message, data);
            return this;
        }

        public Message build() {
            return this.message;
        }
    }
}

