/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.time.Clock;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetCommitQueue;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetCommitQueueMonitor;
import pl.allegro.tech.hermes.domain.subscription.offset.PartitionOffset;

public class SubscriptionOffsetCommitQueues {
    private final LoadingCache<Integer, OffsetCommitQueue> queues;

    public SubscriptionOffsetCommitQueues(Subscription subscription, HermesMetrics hermesMetrics, Clock clock, ConfigFactory configFactory) {
        this.queues = CacheBuilder.newBuilder().build((CacheLoader)new OffsetCommitQueueLoader(subscription, hermesMetrics, clock, configFactory));
    }

    public void put(Message message) {
        OffsetCommitQueue helper = (OffsetCommitQueue)this.queues.getUnchecked((Object)message.getPartition());
        helper.put(message.getOffset());
    }

    public void decrement(int partition, long offset) {
        OffsetCommitQueue offsetCommitQueue = (OffsetCommitQueue)this.queues.getUnchecked((Object)partition);
        offsetCommitQueue.markDelivered(offset);
    }

    public List<PartitionOffset> getOffsetsToCommit() {
        ArrayList<PartitionOffset> offsets = new ArrayList<PartitionOffset>();
        this.queues.asMap().forEach((partition, queue) -> queue.poll().ifPresent(offset -> offsets.add(new PartitionOffset(offset.longValue(), partition.intValue()))));
        return offsets;
    }

    private static final class OffsetCommitQueueLoader
    extends CacheLoader<Integer, OffsetCommitQueue> {
        private final Subscription subscription;
        private final HermesMetrics hermesMetrics;
        private final Clock clock;
        private final ConfigFactory configFactory;

        public OffsetCommitQueueLoader(Subscription subscription, HermesMetrics hermesMetrics, Clock clock, ConfigFactory configFactory) {
            this.subscription = subscription;
            this.hermesMetrics = hermesMetrics;
            this.clock = clock;
            this.configFactory = configFactory;
        }

        public OffsetCommitQueue load(Integer partition) throws Exception {
            return new OffsetCommitQueue(new OffsetCommitQueueMonitor(this.subscription, partition, this.hermesMetrics, this.clock, this.configFactory.getIntProperty(Configs.CONSUMER_OFFSET_COMMIT_QUEUE_ALERT_MINIMAL_IDLE_PERIOD), this.configFactory.getIntProperty(Configs.CONSUMER_OFFSET_COMMIT_QUEUE_ALERT_SIZE)));
        }
    }
}

