/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.CompletableFutureAwareMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;

public class JettyMessageSender
extends CompletableFutureAwareMessageSender {
    private final HttpClient client;
    private final ResolvableEndpointAddress endpoint;
    private final long timeout;

    public JettyMessageSender(HttpClient client, ResolvableEndpointAddress endpoint, int timeout) {
        this.client = client;
        this.endpoint = endpoint;
        this.timeout = timeout;
    }

    @Override
    protected void sendMessage(Message message, CompletableFuture<MessageSendingResult> resultFuture) {
        try {
            this.client.newRequest(this.endpoint.resolveFor(message)).method(HttpMethod.POST).header(HttpHeader.KEEP_ALIVE.toString(), "true").header(MessageMetadataHeaders.MESSAGE_ID.getName(), message.getId()).header(HttpHeader.CONTENT_TYPE.toString(), "application/json").timeout(this.timeout, TimeUnit.MILLISECONDS).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{message.getData()})).send(result -> resultFuture.complete(new MessageSendingResult(result)));
        }
        catch (EndpointAddressResolutionException exception) {
            resultFuture.complete(MessageSendingResult.failedResult(exception));
        }
    }

    @Override
    public void stop() {
    }
}

