/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.jms;

import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.jms.AbstractJmsMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.uri.UriUtils;

public class JmsHornetQMessageSenderProvider
extends AbstractJmsMessageSenderProvider {
    @Inject
    public JmsHornetQMessageSenderProvider(ConfigFactory configFactory) {
        super(configFactory);
    }

    @Override
    public ConnectionFactory createConnectionFactory(URI serverUri) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("host", UriUtils.extractHostFromUri(serverUri));
        Integer port = UriUtils.extractPortFromUri(serverUri);
        if (port != null) {
            props.put("port", port);
        }
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), props);
        return HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
    }
}

