/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.timeout;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class FutureAsyncTimeout<T> {
    private final ScheduledExecutorService executor;
    private final Function<TimeoutException, T> failure;

    public FutureAsyncTimeout(Function<TimeoutException, T> failure, ScheduledExecutorService scheduledExecutorService) {
        this.executor = scheduledExecutorService;
        this.failure = failure;
    }

    public CompletableFuture<T> within(CompletableFuture<T> future, Duration duration) {
        return future.applyToEither((CompletionStage)this.failAfter(duration), Function.identity());
    }

    private CompletableFuture<T> failAfter(Duration duration) {
        CompletableFuture promise = new CompletableFuture();
        this.executor.schedule(() -> {
            TimeoutException ex = new TimeoutException("Timeout after " + duration);
            return promise.complete(this.failure.apply(ex));
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

