/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.di;

import java.util.List;
import javax.inject.Singleton;
import org.eclipse.jetty.client.HttpClient;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.di.factories.UndeliveredMessageLogFactory;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedExecutorServiceFactory;
import pl.allegro.tech.hermes.consumers.consumer.ConsumerMessageSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.converter.MessageConverterFactory;
import pl.allegro.tech.hermes.consumers.consumer.interpolation.MessageBodyInterpolator;
import pl.allegro.tech.hermes.consumers.consumer.interpolation.UriInterpolator;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetsStorage;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.broker.BlockingChannelFactory;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.broker.BrokerOffsetsRepository;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.broker.KafkaOffsetsStorage;
import pl.allegro.tech.hermes.consumers.consumer.offset.kafka.zookeeper.ZookeeperOffsetsStorage;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimitSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.receiver.MessageCommitter;
import pl.allegro.tech.hermes.consumers.consumer.receiver.ReceiverFactory;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.KafkaMessageReceiverFactory;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.MessageCommitterFactory;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.OffsetStoragesFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpClientFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyHttpMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.jms.JmsHornetQMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.InterpolatingEndpointAddressResolver;
import pl.allegro.tech.hermes.consumers.consumer.sender.timeout.FutureAsyncTimeout;
import pl.allegro.tech.hermes.consumers.consumer.sender.timeout.FutureAsyncTimeoutFactory;
import pl.allegro.tech.hermes.consumers.health.HealthCheckServer;
import pl.allegro.tech.hermes.consumers.message.undelivered.UndeliveredMessageLogPersister;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.zookeeper.ZookeeperSubscriptionsCacheFactory;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumerFactory;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersExecutorService;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;

public class ConsumersBinder
extends AbstractBinder {
    protected void configure() {
        this.bindSingleton(HealthCheckServer.class);
        this.bind(KafkaMessageReceiverFactory.class).in(Singleton.class).to(ReceiverFactory.class);
        this.bindSingleton(BrokerOffsetsRepository.class);
        this.bind(ZookeeperOffsetsStorage.class).in(Singleton.class).to(OffsetsStorage.class).named("zookeeperOffsetsStorage");
        this.bind(KafkaOffsetsStorage.class).in(Singleton.class).to(OffsetsStorage.class).named("kafkaOffsetsStorage");
        this.bindFactory(MessageCommitterFactory.class).in(Singleton.class).to((TypeLiteral)new TypeLiteral<List<MessageCommitter>>(){});
        this.bind(MessageBodyInterpolator.class).in(Singleton.class).to(UriInterpolator.class);
        this.bind(InterpolatingEndpointAddressResolver.class).to(EndpointAddressResolver.class).in(Singleton.class);
        this.bind(JmsHornetQMessageSenderProvider.class).to(ProtocolMessageSenderProvider.class).in(Singleton.class).named("defaultJmsMessageSenderProvider");
        this.bind(JettyHttpMessageSenderProvider.class).to(ProtocolMessageSenderProvider.class).in(Singleton.class).named("defaultHttpMessageSenderProvider");
        this.bindSingleton(ConsumersSupervisor.class);
        this.bindSingleton(MessageSenderFactory.class);
        this.bindSingleton(ConsumerFactory.class);
        this.bindSingleton(ConsumerRateLimitSupervisor.class);
        this.bindSingleton(OutputRateCalculator.class);
        this.bindSingleton(ConsumersExecutorService.class);
        this.bindSingleton(ZookeeperAdminCache.class);
        this.bindSingleton(InstrumentedExecutorServiceFactory.class);
        this.bindSingleton(ConsumerMessageSenderFactory.class);
        this.bindSingleton(MessageConverterFactory.class);
        this.bindSingleton(BlockingChannelFactory.class);
        this.bindFactory(OffsetStoragesFactory.class).in(Singleton.class).to((TypeLiteral)new TypeLiteral<List<OffsetsStorage>>(){});
        this.bindFactory(FutureAsyncTimeoutFactory.class).in(Singleton.class).to((TypeLiteral)new TypeLiteral<FutureAsyncTimeout<MessageSendingResult>>(){});
        this.bindFactory(HttpClientFactory.class).in(Singleton.class).to(HttpClient.class);
        this.bindFactory(ZookeeperSubscriptionsCacheFactory.class).to(SubscriptionsCache.class).in(Singleton.class);
        this.bindFactory(UndeliveredMessageLogFactory.class).in(Singleton.class).to(UndeliveredMessageLog.class);
        this.bindSingleton(UndeliveredMessageLogPersister.class);
    }

    private <T> void bindSingleton(Class<T> clazz) {
        this.bind(clazz).in(Singleton.class).to(clazz);
    }
}

