/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.metric.timer.ConsumerLatencyTimer;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.rate.InflightsPool;
import pl.allegro.tech.hermes.consumers.consumer.rate.SerialConsumerRateLimiter;
import pl.allegro.tech.hermes.consumers.consumer.result.ErrorHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.SuccessHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResultLogInfo;
import pl.allegro.tech.hermes.consumers.consumer.sender.timeout.FutureAsyncTimeout;

public class ConsumerMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerMessageSender.class);
    private final ScheduledExecutorService retrySingleThreadExecutor;
    private final ExecutorService deliveryReportingExecutor;
    private final SuccessHandler successHandler;
    private final ErrorHandler errorHandler;
    private final SerialConsumerRateLimiter rateLimiter;
    private final MessageSenderFactory messageSenderFactory;
    private final InflightsPool inflight;
    private final FutureAsyncTimeout<MessageSendingResult> async;
    private final int asyncTimeoutMs;
    private int requestTimeoutMs;
    private ConsumerLatencyTimer consumerLatencyTimer;
    private MessageSender messageSender;
    private Subscription subscription;
    private volatile boolean running = true;

    public ConsumerMessageSender(Subscription subscription, MessageSenderFactory messageSenderFactory, SuccessHandler successHandler, ErrorHandler errorHandler, SerialConsumerRateLimiter rateLimiter, ExecutorService deliveryReportingExecutor, InflightsPool inflight, HermesMetrics hermesMetrics, int asyncTimeoutMs, FutureAsyncTimeout<MessageSendingResult> futureAsyncTimeout) {
        this.deliveryReportingExecutor = deliveryReportingExecutor;
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
        this.rateLimiter = rateLimiter;
        this.messageSenderFactory = messageSenderFactory;
        this.messageSender = messageSenderFactory.create(subscription);
        this.subscription = subscription;
        this.inflight = inflight;
        this.retrySingleThreadExecutor = Executors.newScheduledThreadPool(1);
        this.async = futureAsyncTimeout;
        this.requestTimeoutMs = subscription.getSerialSubscriptionPolicy().getRequestTimeout();
        this.asyncTimeoutMs = asyncTimeoutMs;
        this.consumerLatencyTimer = hermesMetrics.latencyTimer(subscription);
    }

    public void shutdown() {
        this.running = false;
    }

    public void sendAsync(Message message) {
        this.sendAsync(message, 0);
    }

    private void sendAsync(Message message, int delayMillis) {
        this.retrySingleThreadExecutor.schedule(() -> this.sendMessage(message), (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    public void sendMessage(Message message) {
        this.rateLimiter.acquire();
        ConsumerLatencyTimer.Context timer = this.consumerLatencyTimer.time();
        CompletableFuture<MessageSendingResult> response = this.async.within(this.messageSender.send(message), Duration.ofMillis(this.asyncTimeoutMs + this.requestTimeoutMs));
        response.thenAcceptAsync((Consumer)new ResponseHandlingListener(message, timer), (Executor)this.deliveryReportingExecutor);
    }

    public synchronized void updateSubscription(Subscription newSubscription) {
        boolean endpointUpdated = !this.subscription.getEndpoint().equals((Object)newSubscription.getEndpoint());
        boolean subscriptionPolicyUpdated = !Objects.equals(this.subscription.getSerialSubscriptionPolicy(), newSubscription.getSerialSubscriptionPolicy());
        boolean endpointAddressResolverMetadataChanged = !Objects.equals(this.subscription.getEndpointAddressResolverMetadata(), newSubscription.getEndpointAddressResolverMetadata());
        this.requestTimeoutMs = newSubscription.getSerialSubscriptionPolicy().getRequestTimeout();
        this.subscription = newSubscription;
        if (endpointUpdated || subscriptionPolicyUpdated || endpointAddressResolverMetadataChanged) {
            this.messageSender = this.messageSenderFactory.create(newSubscription);
        }
    }

    private boolean willExceedTtl(Message message, long delay) {
        long ttl = TimeUnit.SECONDS.toMillis(this.subscription.getSerialSubscriptionPolicy().getMessageTtl().intValue());
        long remainingTtl = Math.max(ttl - delay, 0L);
        return message.isTtlExceeded(remainingTtl);
    }

    private void handleFailedSending(Message message, MessageSendingResult result) {
        if (result.ignoreInRateCalculation(this.subscription.getSerialSubscriptionPolicy().isRetryClientErrors())) {
            this.rateLimiter.registerSuccessfulSending();
        } else {
            this.rateLimiter.registerFailedSending();
        }
        this.errorHandler.handleFailed(message, this.subscription, result);
    }

    private void handleMessageDiscarding(Message message, MessageSendingResult result) {
        this.inflight.release();
        this.errorHandler.handleDiscarded(message, this.subscription, result);
    }

    private void handleMessageSendingSuccess(Message message, MessageSendingResult result) {
        this.inflight.release();
        this.successHandler.handle(message, this.subscription, result);
    }

    private boolean messageSentSucceeded(MessageSendingResult result) {
        return result.succeeded() || result.isClientError() && this.subscription.getSerialSubscriptionPolicy().isRetryClientErrors() == false;
    }

    private boolean shouldResendMessage(MessageSendingResult result) {
        return !result.succeeded() && (!result.isClientError() || this.subscription.getSerialSubscriptionPolicy().isRetryClientErrors() != false);
    }

    class ResponseHandlingListener
    implements Consumer<MessageSendingResult> {
        private final Message message;
        private final ConsumerLatencyTimer.Context timer;

        public ResponseHandlingListener(Message message, ConsumerLatencyTimer.Context timer) {
            this.message = message;
            this.timer = timer;
        }

        @Override
        public void accept(MessageSendingResult result) {
            this.timer.stop();
            if (result.succeeded()) {
                ConsumerMessageSender.this.rateLimiter.registerSuccessfulSending();
                ConsumerMessageSender.this.handleMessageSendingSuccess(this.message, result);
            } else {
                ConsumerMessageSender.this.handleFailedSending(this.message, result);
                List<String> succeededUris = result.getSucceededUris(x$0 -> ConsumerMessageSender.this.messageSentSucceeded(x$0));
                this.message.incrementRetryCounter(succeededUris);
                long retryDelay = this.extractRetryDelay(result);
                if (ConsumerMessageSender.this.running && this.shouldAttemptResending(result, retryDelay)) {
                    ConsumerMessageSender.this.retrySingleThreadExecutor.schedule(() -> this.retrySending(result), retryDelay, TimeUnit.MILLISECONDS);
                } else {
                    ConsumerMessageSender.this.handleMessageDiscarding(this.message, result);
                }
            }
        }

        private boolean shouldAttemptResending(MessageSendingResult result, long retryDelay) {
            return !ConsumerMessageSender.this.willExceedTtl(this.message, retryDelay) && ConsumerMessageSender.this.shouldResendMessage(result);
        }

        private long extractRetryDelay(MessageSendingResult result) {
            long defaultBackoff = ConsumerMessageSender.this.subscription.getSerialSubscriptionPolicy().getMessageBackoff().intValue();
            long ttl = TimeUnit.SECONDS.toMillis(ConsumerMessageSender.this.subscription.getSerialSubscriptionPolicy().getMessageTtl().intValue());
            return result.getRetryAfterMillis().map(delay -> Math.min(delay, ttl)).orElse(defaultBackoff);
        }

        private void retrySending(MessageSendingResult result) {
            if (result.isLoggable()) {
                result.getLogInfo().stream().forEach(this::logResultInfo);
            }
            ConsumerMessageSender.this.sendMessage(this.message);
        }

        private void logResultInfo(MessageSendingResultLogInfo logInfo) {
            logger.debug(String.format("Retrying message send to endpoint %s; messageId %s; offset: %s; partition: %s; sub id: %s; rootCause: %s", logInfo.getUrl(), this.message.getId(), this.message.getOffset(), this.message.getPartition(), ConsumerMessageSender.this.subscription.getQualifiedName(), logInfo.getRootCause()), logInfo.getFailure());
        }
    }
}

