/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetQueue;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.result.AbstractHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.ErrorHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultErrorHandler
extends AbstractHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultErrorHandler.class);
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final Clock clock;
    private final Trackers trackers;
    private final String cluster;

    public DefaultErrorHandler(OffsetQueue offsetQueue, HermesMetrics hermesMetrics, UndeliveredMessageLog undeliveredMessageLog, Clock clock, Trackers trackers, String cluster) {
        super(offsetQueue, hermesMetrics);
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.clock = clock;
        this.trackers = trackers;
        this.cluster = cluster;
    }

    @Override
    public void handleDiscarded(Message message, Subscription subscription, MessageSendingResult result) {
        this.logResult(message, subscription, result);
        this.offsetQueue.offerCommittedOffset(SubscriptionPartitionOffset.subscriptionPartitionOffset(message, subscription));
        this.updateMeters(subscription);
        this.updateMetrics("discarded.$group.$topic.$subscription", message, subscription);
        this.addToMessageLog(message, subscription, result);
        this.trackers.get(subscription).logDiscarded(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause());
    }

    private void addToMessageLog(Message message, Subscription subscription, MessageSendingResult result) {
        result.getLogInfo().forEach(logInfo -> this.undeliveredMessageLog.add(SentMessageTrace.createUndeliveredMessage((Subscription)subscription, (String)new String(message.getData()), (Throwable)logInfo.getFailure(), (Long)this.clock.millis(), (Integer)message.getPartition(), (Long)message.getOffset(), (String)this.cluster)));
    }

    private void logResult(Message message, Subscription subscription, MessageSendingResult result) {
        if (result.isLoggable()) {
            result.getLogInfo().stream().forEach(logInfo -> logger.warn("Abnormal delivery failure: subscription: {}; cause: {}; endpoint: {}; messageId: {}; partition: {}; offset: {}", new Object[]{subscription.getQualifiedName(), logInfo.getRootCause(), logInfo.getUrl(), message.getId(), message.getPartition(), message.getOffset(), logInfo.getFailure()}));
        }
    }

    private void updateMeters(Subscription subscription) {
        this.hermesMetrics.meter("discarded-meter").mark();
        this.hermesMetrics.meter("discarded-meter.$group.$topic", subscription.getTopicName()).mark();
        this.hermesMetrics.meter("discarded-meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark();
    }

    @Override
    public void handleFailed(Message message, Subscription subscription, MessageSendingResult result) {
        this.hermesMetrics.meter("failed-meter.$subscription", subscription.getTopicName(), subscription.getName()).mark();
        this.registerFailureMetrics(subscription, result);
        this.trackers.get(subscription).logFailed(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause());
    }

    private void registerFailureMetrics(Subscription subscription, MessageSendingResult result) {
        if (result.hasHttpAnswer()) {
            this.hermesMetrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
        } else if (result.isTimeout()) {
            this.hermesMetrics.consumerErrorsTimeoutMeter(subscription).mark();
        } else {
            this.hermesMetrics.consumerErrorsOtherMeter(subscription).mark();
        }
    }
}

